/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.CreateProfileDetails;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.Profile;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="profileType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateSoftwareSourceProfileDetails
extends CreateProfileDetails {
    @JsonProperty(value="vendorName")
    private final VendorName vendorName;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="archType")
    private final ArchType archType;
    @JsonProperty(value="softwareSourceIds")
    private final List<String> softwareSourceIds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateSoftwareSourceProfileDetails(String displayName, String compartmentId, String description, String managementStationId, Profile.RegistrationType registrationType, Boolean isDefaultProfile, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, VendorName vendorName, OsFamily osFamily, ArchType archType, List<String> softwareSourceIds) {
        super(displayName, compartmentId, description, managementStationId, registrationType, isDefaultProfile, freeformTags, definedTags);
        this.vendorName = vendorName;
        this.osFamily = osFamily;
        this.archType = archType;
        this.softwareSourceIds = softwareSourceIds;
    }

    public VendorName getVendorName() {
        return this.vendorName;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ArchType getArchType() {
        return this.archType;
    }

    public List<String> getSoftwareSourceIds() {
        return this.softwareSourceIds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSoftwareSourceProfileDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vendorName=").append(String.valueOf((Object)this.vendorName));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", archType=").append(String.valueOf((Object)this.archType));
        sb.append(", softwareSourceIds=").append(String.valueOf(this.softwareSourceIds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSoftwareSourceProfileDetails)) {
            return false;
        }
        CreateSoftwareSourceProfileDetails other = (CreateSoftwareSourceProfileDetails)((Object)o);
        return Objects.equals((Object)this.vendorName, (Object)other.vendorName) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals(this.softwareSourceIds, other.softwareSourceIds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.softwareSourceIds == null ? 43 : this.softwareSourceIds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="managementStationId")
        private String managementStationId;
        @JsonProperty(value="registrationType")
        private Profile.RegistrationType registrationType;
        @JsonProperty(value="isDefaultProfile")
        private Boolean isDefaultProfile;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vendorName")
        private VendorName vendorName;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="archType")
        private ArchType archType;
        @JsonProperty(value="softwareSourceIds")
        private List<String> softwareSourceIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder managementStationId(String managementStationId) {
            this.managementStationId = managementStationId;
            this.__explicitlySet__.add("managementStationId");
            return this;
        }

        public Builder registrationType(Profile.RegistrationType registrationType) {
            this.registrationType = registrationType;
            this.__explicitlySet__.add("registrationType");
            return this;
        }

        public Builder isDefaultProfile(Boolean isDefaultProfile) {
            this.isDefaultProfile = isDefaultProfile;
            this.__explicitlySet__.add("isDefaultProfile");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vendorName(VendorName vendorName) {
            this.vendorName = vendorName;
            this.__explicitlySet__.add("vendorName");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder archType(ArchType archType) {
            this.archType = archType;
            this.__explicitlySet__.add("archType");
            return this;
        }

        public Builder softwareSourceIds(List<String> softwareSourceIds) {
            this.softwareSourceIds = softwareSourceIds;
            this.__explicitlySet__.add("softwareSourceIds");
            return this;
        }

        public CreateSoftwareSourceProfileDetails build() {
            CreateSoftwareSourceProfileDetails model = new CreateSoftwareSourceProfileDetails(this.displayName, this.compartmentId, this.description, this.managementStationId, this.registrationType, this.isDefaultProfile, this.freeformTags, this.definedTags, this.vendorName, this.osFamily, this.archType, this.softwareSourceIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSoftwareSourceProfileDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("managementStationId")) {
                this.managementStationId(model.getManagementStationId());
            }
            if (model.wasPropertyExplicitlySet("registrationType")) {
                this.registrationType(model.getRegistrationType());
            }
            if (model.wasPropertyExplicitlySet("isDefaultProfile")) {
                this.isDefaultProfile(model.getIsDefaultProfile());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vendorName")) {
                this.vendorName(model.getVendorName());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("archType")) {
                this.archType(model.getArchType());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceIds")) {
                this.softwareSourceIds(model.getSoftwareSourceIds());
            }
            return this;
        }
    }
}

