/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.CreateSoftwareSourceDetails;
import com.oracle.bmc.osmanagementhub.model.CustomSoftwareSourceFilter;
import com.oracle.bmc.osmanagementhub.model.Id;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="softwareSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateVersionedCustomSoftwareSourceDetails
extends CreateSoftwareSourceDetails {
    @JsonProperty(value="vendorSoftwareSources")
    private final List<Id> vendorSoftwareSources;
    @JsonProperty(value="customSoftwareSourceFilter")
    private final CustomSoftwareSourceFilter customSoftwareSourceFilter;
    @JsonProperty(value="softwareSourceVersion")
    private final String softwareSourceVersion;
    @JsonProperty(value="isAutoResolveDependencies")
    private final Boolean isAutoResolveDependencies;
    @JsonProperty(value="isCreatedFromPackageList")
    private final Boolean isCreatedFromPackageList;
    @JsonProperty(value="isLatestContentOnly")
    private final Boolean isLatestContentOnly;
    @JsonProperty(value="packages")
    private final List<String> packages;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateVersionedCustomSoftwareSourceDetails(String compartmentId, String displayName, String description, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<Id> vendorSoftwareSources, CustomSoftwareSourceFilter customSoftwareSourceFilter, String softwareSourceVersion, Boolean isAutoResolveDependencies, Boolean isCreatedFromPackageList, Boolean isLatestContentOnly, List<String> packages) {
        super(compartmentId, displayName, description, freeformTags, definedTags);
        this.vendorSoftwareSources = vendorSoftwareSources;
        this.customSoftwareSourceFilter = customSoftwareSourceFilter;
        this.softwareSourceVersion = softwareSourceVersion;
        this.isAutoResolveDependencies = isAutoResolveDependencies;
        this.isCreatedFromPackageList = isCreatedFromPackageList;
        this.isLatestContentOnly = isLatestContentOnly;
        this.packages = packages;
    }

    public List<Id> getVendorSoftwareSources() {
        return this.vendorSoftwareSources;
    }

    public CustomSoftwareSourceFilter getCustomSoftwareSourceFilter() {
        return this.customSoftwareSourceFilter;
    }

    public String getSoftwareSourceVersion() {
        return this.softwareSourceVersion;
    }

    public Boolean getIsAutoResolveDependencies() {
        return this.isAutoResolveDependencies;
    }

    public Boolean getIsCreatedFromPackageList() {
        return this.isCreatedFromPackageList;
    }

    public Boolean getIsLatestContentOnly() {
        return this.isLatestContentOnly;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateVersionedCustomSoftwareSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vendorSoftwareSources=").append(String.valueOf(this.vendorSoftwareSources));
        sb.append(", customSoftwareSourceFilter=").append(String.valueOf((Object)this.customSoftwareSourceFilter));
        sb.append(", softwareSourceVersion=").append(String.valueOf(this.softwareSourceVersion));
        sb.append(", isAutoResolveDependencies=").append(String.valueOf(this.isAutoResolveDependencies));
        sb.append(", isCreatedFromPackageList=").append(String.valueOf(this.isCreatedFromPackageList));
        sb.append(", isLatestContentOnly=").append(String.valueOf(this.isLatestContentOnly));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVersionedCustomSoftwareSourceDetails)) {
            return false;
        }
        CreateVersionedCustomSoftwareSourceDetails other = (CreateVersionedCustomSoftwareSourceDetails)((Object)o);
        return Objects.equals(this.vendorSoftwareSources, other.vendorSoftwareSources) && Objects.equals((Object)this.customSoftwareSourceFilter, (Object)other.customSoftwareSourceFilter) && Objects.equals(this.softwareSourceVersion, other.softwareSourceVersion) && Objects.equals(this.isAutoResolveDependencies, other.isAutoResolveDependencies) && Objects.equals(this.isCreatedFromPackageList, other.isCreatedFromPackageList) && Objects.equals(this.isLatestContentOnly, other.isLatestContentOnly) && Objects.equals(this.packages, other.packages) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vendorSoftwareSources == null ? 43 : this.vendorSoftwareSources.hashCode());
        result = result * 59 + (this.customSoftwareSourceFilter == null ? 43 : this.customSoftwareSourceFilter.hashCode());
        result = result * 59 + (this.softwareSourceVersion == null ? 43 : this.softwareSourceVersion.hashCode());
        result = result * 59 + (this.isAutoResolveDependencies == null ? 43 : this.isAutoResolveDependencies.hashCode());
        result = result * 59 + (this.isCreatedFromPackageList == null ? 43 : this.isCreatedFromPackageList.hashCode());
        result = result * 59 + (this.isLatestContentOnly == null ? 43 : this.isLatestContentOnly.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vendorSoftwareSources")
        private List<Id> vendorSoftwareSources;
        @JsonProperty(value="customSoftwareSourceFilter")
        private CustomSoftwareSourceFilter customSoftwareSourceFilter;
        @JsonProperty(value="softwareSourceVersion")
        private String softwareSourceVersion;
        @JsonProperty(value="isAutoResolveDependencies")
        private Boolean isAutoResolveDependencies;
        @JsonProperty(value="isCreatedFromPackageList")
        private Boolean isCreatedFromPackageList;
        @JsonProperty(value="isLatestContentOnly")
        private Boolean isLatestContentOnly;
        @JsonProperty(value="packages")
        private List<String> packages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vendorSoftwareSources(List<Id> vendorSoftwareSources) {
            this.vendorSoftwareSources = vendorSoftwareSources;
            this.__explicitlySet__.add("vendorSoftwareSources");
            return this;
        }

        public Builder customSoftwareSourceFilter(CustomSoftwareSourceFilter customSoftwareSourceFilter) {
            this.customSoftwareSourceFilter = customSoftwareSourceFilter;
            this.__explicitlySet__.add("customSoftwareSourceFilter");
            return this;
        }

        public Builder softwareSourceVersion(String softwareSourceVersion) {
            this.softwareSourceVersion = softwareSourceVersion;
            this.__explicitlySet__.add("softwareSourceVersion");
            return this;
        }

        public Builder isAutoResolveDependencies(Boolean isAutoResolveDependencies) {
            this.isAutoResolveDependencies = isAutoResolveDependencies;
            this.__explicitlySet__.add("isAutoResolveDependencies");
            return this;
        }

        public Builder isCreatedFromPackageList(Boolean isCreatedFromPackageList) {
            this.isCreatedFromPackageList = isCreatedFromPackageList;
            this.__explicitlySet__.add("isCreatedFromPackageList");
            return this;
        }

        public Builder isLatestContentOnly(Boolean isLatestContentOnly) {
            this.isLatestContentOnly = isLatestContentOnly;
            this.__explicitlySet__.add("isLatestContentOnly");
            return this;
        }

        public Builder packages(List<String> packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public CreateVersionedCustomSoftwareSourceDetails build() {
            CreateVersionedCustomSoftwareSourceDetails model = new CreateVersionedCustomSoftwareSourceDetails(this.compartmentId, this.displayName, this.description, this.freeformTags, this.definedTags, this.vendorSoftwareSources, this.customSoftwareSourceFilter, this.softwareSourceVersion, this.isAutoResolveDependencies, this.isCreatedFromPackageList, this.isLatestContentOnly, this.packages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateVersionedCustomSoftwareSourceDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vendorSoftwareSources")) {
                this.vendorSoftwareSources(model.getVendorSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("customSoftwareSourceFilter")) {
                this.customSoftwareSourceFilter(model.getCustomSoftwareSourceFilter());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceVersion")) {
                this.softwareSourceVersion(model.getSoftwareSourceVersion());
            }
            if (model.wasPropertyExplicitlySet("isAutoResolveDependencies")) {
                this.isAutoResolveDependencies(model.getIsAutoResolveDependencies());
            }
            if (model.wasPropertyExplicitlySet("isCreatedFromPackageList")) {
                this.isCreatedFromPackageList(model.getIsCreatedFromPackageList());
            }
            if (model.wasPropertyExplicitlySet("isLatestContentOnly")) {
                this.isLatestContentOnly(model.getIsLatestContentOnly());
            }
            if (model.wasPropertyExplicitlySet("packages")) {
                this.packages(model.getPackages());
            }
            return this;
        }
    }
}

