/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamProfileFilter;
import com.oracle.bmc.osmanagementhub.model.PackageFilter;
import com.oracle.bmc.osmanagementhub.model.PackageGroupFilter;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomSoftwareSourceFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="packageFilters")
    private final List<PackageFilter> packageFilters;
    @JsonProperty(value="moduleStreamProfileFilters")
    private final List<ModuleStreamProfileFilter> moduleStreamProfileFilters;
    @JsonProperty(value="packageGroupFilters")
    private final List<PackageGroupFilter> packageGroupFilters;

    @Deprecated
    @ConstructorProperties(value={"packageFilters", "moduleStreamProfileFilters", "packageGroupFilters"})
    public CustomSoftwareSourceFilter(List<PackageFilter> packageFilters, List<ModuleStreamProfileFilter> moduleStreamProfileFilters, List<PackageGroupFilter> packageGroupFilters) {
        this.packageFilters = packageFilters;
        this.moduleStreamProfileFilters = moduleStreamProfileFilters;
        this.packageGroupFilters = packageGroupFilters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<PackageFilter> getPackageFilters() {
        return this.packageFilters;
    }

    public List<ModuleStreamProfileFilter> getModuleStreamProfileFilters() {
        return this.moduleStreamProfileFilters;
    }

    public List<PackageGroupFilter> getPackageGroupFilters() {
        return this.packageGroupFilters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomSoftwareSourceFilter(");
        sb.append("super=").append(super.toString());
        sb.append("packageFilters=").append(String.valueOf(this.packageFilters));
        sb.append(", moduleStreamProfileFilters=").append(String.valueOf(this.moduleStreamProfileFilters));
        sb.append(", packageGroupFilters=").append(String.valueOf(this.packageGroupFilters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomSoftwareSourceFilter)) {
            return false;
        }
        CustomSoftwareSourceFilter other = (CustomSoftwareSourceFilter)((Object)o);
        return Objects.equals(this.packageFilters, other.packageFilters) && Objects.equals(this.moduleStreamProfileFilters, other.moduleStreamProfileFilters) && Objects.equals(this.packageGroupFilters, other.packageGroupFilters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.packageFilters == null ? 43 : this.packageFilters.hashCode());
        result = result * 59 + (this.moduleStreamProfileFilters == null ? 43 : this.moduleStreamProfileFilters.hashCode());
        result = result * 59 + (this.packageGroupFilters == null ? 43 : this.packageGroupFilters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="packageFilters")
        private List<PackageFilter> packageFilters;
        @JsonProperty(value="moduleStreamProfileFilters")
        private List<ModuleStreamProfileFilter> moduleStreamProfileFilters;
        @JsonProperty(value="packageGroupFilters")
        private List<PackageGroupFilter> packageGroupFilters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder packageFilters(List<PackageFilter> packageFilters) {
            this.packageFilters = packageFilters;
            this.__explicitlySet__.add("packageFilters");
            return this;
        }

        public Builder moduleStreamProfileFilters(List<ModuleStreamProfileFilter> moduleStreamProfileFilters) {
            this.moduleStreamProfileFilters = moduleStreamProfileFilters;
            this.__explicitlySet__.add("moduleStreamProfileFilters");
            return this;
        }

        public Builder packageGroupFilters(List<PackageGroupFilter> packageGroupFilters) {
            this.packageGroupFilters = packageGroupFilters;
            this.__explicitlySet__.add("packageGroupFilters");
            return this;
        }

        public CustomSoftwareSourceFilter build() {
            CustomSoftwareSourceFilter model = new CustomSoftwareSourceFilter(this.packageFilters, this.moduleStreamProfileFilters, this.packageGroupFilters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomSoftwareSourceFilter model) {
            if (model.wasPropertyExplicitlySet("packageFilters")) {
                this.packageFilters(model.getPackageFilters());
            }
            if (model.wasPropertyExplicitlySet("moduleStreamProfileFilters")) {
                this.moduleStreamProfileFilters(model.getModuleStreamProfileFilters());
            }
            if (model.wasPropertyExplicitlySet("packageGroupFilters")) {
                this.packageGroupFilters(model.getPackageGroupFilters());
            }
            return this;
        }
    }
}

