/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.AdvisorySeverity;
import com.oracle.bmc.osmanagementhub.model.AdvisoryTypes;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwarePackageSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Erratum
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="synopsis")
    private final String synopsis;
    @JsonProperty(value="timeIssued")
    private final Date timeIssued;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="classificationType")
    private final ClassificationTypes classificationType;
    @JsonProperty(value="advisoryType")
    private final AdvisoryTypes advisoryType;
    @JsonProperty(value="from")
    private final String from;
    @JsonProperty(value="solution")
    private final String solution;
    @JsonProperty(value="references")
    private final String references;
    @JsonProperty(value="relatedCves")
    private final List<String> relatedCves;
    @JsonProperty(value="repositories")
    private final List<String> repositories;
    @JsonProperty(value="packages")
    private final List<SoftwarePackageSummary> packages;
    @JsonProperty(value="osFamilies")
    private final List<OsFamily> osFamilies;
    @JsonProperty(value="advisorySeverity")
    private final AdvisorySeverity advisorySeverity;

    @Deprecated
    @ConstructorProperties(value={"name", "synopsis", "timeIssued", "description", "timeUpdated", "classificationType", "advisoryType", "from", "solution", "references", "relatedCves", "repositories", "packages", "osFamilies", "advisorySeverity"})
    public Erratum(String name, String synopsis, Date timeIssued, String description, Date timeUpdated, ClassificationTypes classificationType, AdvisoryTypes advisoryType, String from, String solution, String references, List<String> relatedCves, List<String> repositories, List<SoftwarePackageSummary> packages, List<OsFamily> osFamilies, AdvisorySeverity advisorySeverity) {
        this.name = name;
        this.synopsis = synopsis;
        this.timeIssued = timeIssued;
        this.description = description;
        this.timeUpdated = timeUpdated;
        this.classificationType = classificationType;
        this.advisoryType = advisoryType;
        this.from = from;
        this.solution = solution;
        this.references = references;
        this.relatedCves = relatedCves;
        this.repositories = repositories;
        this.packages = packages;
        this.osFamilies = osFamilies;
        this.advisorySeverity = advisorySeverity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public Date getTimeIssued() {
        return this.timeIssued;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public ClassificationTypes getClassificationType() {
        return this.classificationType;
    }

    public AdvisoryTypes getAdvisoryType() {
        return this.advisoryType;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getReferences() {
        return this.references;
    }

    public List<String> getRelatedCves() {
        return this.relatedCves;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public List<SoftwarePackageSummary> getPackages() {
        return this.packages;
    }

    public List<OsFamily> getOsFamilies() {
        return this.osFamilies;
    }

    public AdvisorySeverity getAdvisorySeverity() {
        return this.advisorySeverity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Erratum(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", synopsis=").append(String.valueOf(this.synopsis));
        sb.append(", timeIssued=").append(String.valueOf(this.timeIssued));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", classificationType=").append(String.valueOf((Object)this.classificationType));
        sb.append(", advisoryType=").append(String.valueOf((Object)this.advisoryType));
        sb.append(", from=").append(String.valueOf(this.from));
        sb.append(", solution=").append(String.valueOf(this.solution));
        sb.append(", references=").append(String.valueOf(this.references));
        sb.append(", relatedCves=").append(String.valueOf(this.relatedCves));
        sb.append(", repositories=").append(String.valueOf(this.repositories));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(", osFamilies=").append(String.valueOf(this.osFamilies));
        sb.append(", advisorySeverity=").append(String.valueOf((Object)this.advisorySeverity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Erratum)) {
            return false;
        }
        Erratum other = (Erratum)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.synopsis, other.synopsis) && Objects.equals(this.timeIssued, other.timeIssued) && Objects.equals(this.description, other.description) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.classificationType, (Object)other.classificationType) && Objects.equals((Object)this.advisoryType, (Object)other.advisoryType) && Objects.equals(this.from, other.from) && Objects.equals(this.solution, other.solution) && Objects.equals(this.references, other.references) && Objects.equals(this.relatedCves, other.relatedCves) && Objects.equals(this.repositories, other.repositories) && Objects.equals(this.packages, other.packages) && Objects.equals(this.osFamilies, other.osFamilies) && Objects.equals((Object)this.advisorySeverity, (Object)other.advisorySeverity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.synopsis == null ? 43 : this.synopsis.hashCode());
        result = result * 59 + (this.timeIssued == null ? 43 : this.timeIssued.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.classificationType == null ? 43 : this.classificationType.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + (this.from == null ? 43 : this.from.hashCode());
        result = result * 59 + (this.solution == null ? 43 : this.solution.hashCode());
        result = result * 59 + (this.references == null ? 43 : this.references.hashCode());
        result = result * 59 + (this.relatedCves == null ? 43 : this.relatedCves.hashCode());
        result = result * 59 + (this.repositories == null ? 43 : this.repositories.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        result = result * 59 + (this.osFamilies == null ? 43 : this.osFamilies.hashCode());
        result = result * 59 + (this.advisorySeverity == null ? 43 : this.advisorySeverity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="synopsis")
        private String synopsis;
        @JsonProperty(value="timeIssued")
        private Date timeIssued;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="classificationType")
        private ClassificationTypes classificationType;
        @JsonProperty(value="advisoryType")
        private AdvisoryTypes advisoryType;
        @JsonProperty(value="from")
        private String from;
        @JsonProperty(value="solution")
        private String solution;
        @JsonProperty(value="references")
        private String references;
        @JsonProperty(value="relatedCves")
        private List<String> relatedCves;
        @JsonProperty(value="repositories")
        private List<String> repositories;
        @JsonProperty(value="packages")
        private List<SoftwarePackageSummary> packages;
        @JsonProperty(value="osFamilies")
        private List<OsFamily> osFamilies;
        @JsonProperty(value="advisorySeverity")
        private AdvisorySeverity advisorySeverity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder synopsis(String synopsis) {
            this.synopsis = synopsis;
            this.__explicitlySet__.add("synopsis");
            return this;
        }

        public Builder timeIssued(Date timeIssued) {
            this.timeIssued = timeIssued;
            this.__explicitlySet__.add("timeIssued");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder classificationType(ClassificationTypes classificationType) {
            this.classificationType = classificationType;
            this.__explicitlySet__.add("classificationType");
            return this;
        }

        public Builder advisoryType(AdvisoryTypes advisoryType) {
            this.advisoryType = advisoryType;
            this.__explicitlySet__.add("advisoryType");
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            this.__explicitlySet__.add("from");
            return this;
        }

        public Builder solution(String solution) {
            this.solution = solution;
            this.__explicitlySet__.add("solution");
            return this;
        }

        public Builder references(String references) {
            this.references = references;
            this.__explicitlySet__.add("references");
            return this;
        }

        public Builder relatedCves(List<String> relatedCves) {
            this.relatedCves = relatedCves;
            this.__explicitlySet__.add("relatedCves");
            return this;
        }

        public Builder repositories(List<String> repositories) {
            this.repositories = repositories;
            this.__explicitlySet__.add("repositories");
            return this;
        }

        public Builder packages(List<SoftwarePackageSummary> packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public Builder osFamilies(List<OsFamily> osFamilies) {
            this.osFamilies = osFamilies;
            this.__explicitlySet__.add("osFamilies");
            return this;
        }

        public Builder advisorySeverity(AdvisorySeverity advisorySeverity) {
            this.advisorySeverity = advisorySeverity;
            this.__explicitlySet__.add("advisorySeverity");
            return this;
        }

        public Erratum build() {
            Erratum model = new Erratum(this.name, this.synopsis, this.timeIssued, this.description, this.timeUpdated, this.classificationType, this.advisoryType, this.from, this.solution, this.references, this.relatedCves, this.repositories, this.packages, this.osFamilies, this.advisorySeverity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Erratum model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("synopsis")) {
                this.synopsis(model.getSynopsis());
            }
            if (model.wasPropertyExplicitlySet("timeIssued")) {
                this.timeIssued(model.getTimeIssued());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("classificationType")) {
                this.classificationType(model.getClassificationType());
            }
            if (model.wasPropertyExplicitlySet("advisoryType")) {
                this.advisoryType(model.getAdvisoryType());
            }
            if (model.wasPropertyExplicitlySet("from")) {
                this.from(model.getFrom());
            }
            if (model.wasPropertyExplicitlySet("solution")) {
                this.solution(model.getSolution());
            }
            if (model.wasPropertyExplicitlySet("references")) {
                this.references(model.getReferences());
            }
            if (model.wasPropertyExplicitlySet("relatedCves")) {
                this.relatedCves(model.getRelatedCves());
            }
            if (model.wasPropertyExplicitlySet("repositories")) {
                this.repositories(model.getRepositories());
            }
            if (model.wasPropertyExplicitlySet("packages")) {
                this.packages(model.getPackages());
            }
            if (model.wasPropertyExplicitlySet("osFamilies")) {
                this.osFamilies(model.getOsFamilies());
            }
            if (model.wasPropertyExplicitlySet("advisorySeverity")) {
                this.advisorySeverity(model.getAdvisorySeverity());
            }
            return this;
        }
    }
}

