/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.AdvisorySeverity;
import com.oracle.bmc.osmanagementhub.model.AdvisoryTypes;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ErratumSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="synopsis")
    private final String synopsis;
    @JsonProperty(value="timeIssued")
    private final Date timeIssued;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="classificationType")
    private final ClassificationTypes classificationType;
    @JsonProperty(value="relatedCves")
    private final List<String> relatedCves;
    @JsonProperty(value="osFamilies")
    private final List<OsFamily> osFamilies;
    @JsonProperty(value="advisorySeverity")
    private final AdvisorySeverity advisorySeverity;
    @JsonProperty(value="advisoryType")
    private final AdvisoryTypes advisoryType;

    @Deprecated
    @ConstructorProperties(value={"name", "synopsis", "timeIssued", "timeUpdated", "classificationType", "relatedCves", "osFamilies", "advisorySeverity", "advisoryType"})
    public ErratumSummary(String name, String synopsis, Date timeIssued, Date timeUpdated, ClassificationTypes classificationType, List<String> relatedCves, List<OsFamily> osFamilies, AdvisorySeverity advisorySeverity, AdvisoryTypes advisoryType) {
        this.name = name;
        this.synopsis = synopsis;
        this.timeIssued = timeIssued;
        this.timeUpdated = timeUpdated;
        this.classificationType = classificationType;
        this.relatedCves = relatedCves;
        this.osFamilies = osFamilies;
        this.advisorySeverity = advisorySeverity;
        this.advisoryType = advisoryType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public Date getTimeIssued() {
        return this.timeIssued;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public ClassificationTypes getClassificationType() {
        return this.classificationType;
    }

    public List<String> getRelatedCves() {
        return this.relatedCves;
    }

    public List<OsFamily> getOsFamilies() {
        return this.osFamilies;
    }

    public AdvisorySeverity getAdvisorySeverity() {
        return this.advisorySeverity;
    }

    public AdvisoryTypes getAdvisoryType() {
        return this.advisoryType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ErratumSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", synopsis=").append(String.valueOf(this.synopsis));
        sb.append(", timeIssued=").append(String.valueOf(this.timeIssued));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", classificationType=").append(String.valueOf((Object)this.classificationType));
        sb.append(", relatedCves=").append(String.valueOf(this.relatedCves));
        sb.append(", osFamilies=").append(String.valueOf(this.osFamilies));
        sb.append(", advisorySeverity=").append(String.valueOf((Object)this.advisorySeverity));
        sb.append(", advisoryType=").append(String.valueOf((Object)this.advisoryType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErratumSummary)) {
            return false;
        }
        ErratumSummary other = (ErratumSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.synopsis, other.synopsis) && Objects.equals(this.timeIssued, other.timeIssued) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.classificationType, (Object)other.classificationType) && Objects.equals(this.relatedCves, other.relatedCves) && Objects.equals(this.osFamilies, other.osFamilies) && Objects.equals((Object)this.advisorySeverity, (Object)other.advisorySeverity) && Objects.equals((Object)this.advisoryType, (Object)other.advisoryType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.synopsis == null ? 43 : this.synopsis.hashCode());
        result = result * 59 + (this.timeIssued == null ? 43 : this.timeIssued.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.classificationType == null ? 43 : this.classificationType.hashCode());
        result = result * 59 + (this.relatedCves == null ? 43 : this.relatedCves.hashCode());
        result = result * 59 + (this.osFamilies == null ? 43 : this.osFamilies.hashCode());
        result = result * 59 + (this.advisorySeverity == null ? 43 : this.advisorySeverity.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="synopsis")
        private String synopsis;
        @JsonProperty(value="timeIssued")
        private Date timeIssued;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="classificationType")
        private ClassificationTypes classificationType;
        @JsonProperty(value="relatedCves")
        private List<String> relatedCves;
        @JsonProperty(value="osFamilies")
        private List<OsFamily> osFamilies;
        @JsonProperty(value="advisorySeverity")
        private AdvisorySeverity advisorySeverity;
        @JsonProperty(value="advisoryType")
        private AdvisoryTypes advisoryType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder synopsis(String synopsis) {
            this.synopsis = synopsis;
            this.__explicitlySet__.add("synopsis");
            return this;
        }

        public Builder timeIssued(Date timeIssued) {
            this.timeIssued = timeIssued;
            this.__explicitlySet__.add("timeIssued");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder classificationType(ClassificationTypes classificationType) {
            this.classificationType = classificationType;
            this.__explicitlySet__.add("classificationType");
            return this;
        }

        public Builder relatedCves(List<String> relatedCves) {
            this.relatedCves = relatedCves;
            this.__explicitlySet__.add("relatedCves");
            return this;
        }

        public Builder osFamilies(List<OsFamily> osFamilies) {
            this.osFamilies = osFamilies;
            this.__explicitlySet__.add("osFamilies");
            return this;
        }

        public Builder advisorySeverity(AdvisorySeverity advisorySeverity) {
            this.advisorySeverity = advisorySeverity;
            this.__explicitlySet__.add("advisorySeverity");
            return this;
        }

        public Builder advisoryType(AdvisoryTypes advisoryType) {
            this.advisoryType = advisoryType;
            this.__explicitlySet__.add("advisoryType");
            return this;
        }

        public ErratumSummary build() {
            ErratumSummary model = new ErratumSummary(this.name, this.synopsis, this.timeIssued, this.timeUpdated, this.classificationType, this.relatedCves, this.osFamilies, this.advisorySeverity, this.advisoryType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ErratumSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("synopsis")) {
                this.synopsis(model.getSynopsis());
            }
            if (model.wasPropertyExplicitlySet("timeIssued")) {
                this.timeIssued(model.getTimeIssued());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("classificationType")) {
                this.classificationType(model.getClassificationType());
            }
            if (model.wasPropertyExplicitlySet("relatedCves")) {
                this.relatedCves(model.getRelatedCves());
            }
            if (model.wasPropertyExplicitlySet("osFamilies")) {
                this.osFamilies(model.getOsFamilies());
            }
            if (model.wasPropertyExplicitlySet("advisorySeverity")) {
                this.advisorySeverity(model.getAdvisorySeverity());
            }
            if (model.wasPropertyExplicitlySet("advisoryType")) {
                this.advisoryType(model.getAdvisoryType());
            }
            return this;
        }
    }
}

