/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.AgentEvent;
import com.oracle.bmc.osmanagementhub.model.ExploitAttemptEvent;
import com.oracle.bmc.osmanagementhub.model.KernelCrashEvent;
import com.oracle.bmc.osmanagementhub.model.KernelOopsEvent;
import com.oracle.bmc.osmanagementhub.model.KspliceUpdateEvent;
import com.oracle.bmc.osmanagementhub.model.ManagementStationEvent;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceEvent;
import com.oracle.bmc.osmanagementhub.model.SoftwareUpdateEvent;
import com.oracle.bmc.osmanagementhub.model.SystemDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Event.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SoftwareUpdateEvent.class, name="SOFTWARE_UPDATE"), @JsonSubTypes.Type(value=KernelOopsEvent.class, name="KERNEL_OOPS"), @JsonSubTypes.Type(value=ManagementStationEvent.class, name="MANAGEMENT_STATION"), @JsonSubTypes.Type(value=SoftwareSourceEvent.class, name="SOFTWARE_SOURCE"), @JsonSubTypes.Type(value=KernelCrashEvent.class, name="KERNEL_CRASH"), @JsonSubTypes.Type(value=ExploitAttemptEvent.class, name="EXPLOIT_ATTEMPT"), @JsonSubTypes.Type(value=AgentEvent.class, name="AGENT"), @JsonSubTypes.Type(value=KspliceUpdateEvent.class, name="KSPLICE_UPDATE")})
@JsonFilter(value="explicitlySetFilter")
public class Event
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="eventSummary")
    private final String eventSummary;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="eventDetails")
    private final String eventDetails;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="systemDetails")
    private final SystemDetails systemDetails;
    @JsonProperty(value="timeOccurred")
    private final Date timeOccurred;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "eventSummary", "compartmentId", "eventDetails", "resourceId", "systemDetails", "timeOccurred", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "isManagedByAutonomousLinux", "freeformTags", "definedTags", "systemTags"})
    protected Event(String id, String eventSummary, String compartmentId, String eventDetails, String resourceId, SystemDetails systemDetails, Date timeOccurred, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String lifecycleDetails, Boolean isManagedByAutonomousLinux, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.eventSummary = eventSummary;
        this.compartmentId = compartmentId;
        this.eventDetails = eventDetails;
        this.resourceId = resourceId;
        this.systemDetails = systemDetails;
        this.timeOccurred = timeOccurred;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public String getId() {
        return this.id;
    }

    public String getEventSummary() {
        return this.eventSummary;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEventDetails() {
        return this.eventDetails;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public SystemDetails getSystemDetails() {
        return this.systemDetails;
    }

    public Date getTimeOccurred() {
        return this.timeOccurred;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Event(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", eventSummary=").append(String.valueOf(this.eventSummary));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", eventDetails=").append(String.valueOf(this.eventDetails));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", systemDetails=").append(String.valueOf((Object)this.systemDetails));
        sb.append(", timeOccurred=").append(String.valueOf(this.timeOccurred));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.eventSummary, other.eventSummary) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.eventDetails, other.eventDetails) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.systemDetails, (Object)other.systemDetails) && Objects.equals(this.timeOccurred, other.timeOccurred) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.eventSummary == null ? 43 : this.eventSummary.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.eventDetails == null ? 43 : this.eventDetails.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.systemDetails == null ? 43 : this.systemDetails.hashCode());
        result = result * 59 + (this.timeOccurred == null ? 43 : this.timeOccurred.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

