/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.EventContent;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ExploitAttemptEventContent
extends EventContent {
    @JsonProperty(value="exploitDetectionLogContent")
    private final String exploitDetectionLogContent;
    @JsonProperty(value="exploitObjectStoreLocation")
    private final String exploitObjectStoreLocation;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExploitAttemptEventContent(String exploitDetectionLogContent, String exploitObjectStoreLocation) {
        this.exploitDetectionLogContent = exploitDetectionLogContent;
        this.exploitObjectStoreLocation = exploitObjectStoreLocation;
    }

    public String getExploitDetectionLogContent() {
        return this.exploitDetectionLogContent;
    }

    public String getExploitObjectStoreLocation() {
        return this.exploitObjectStoreLocation;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExploitAttemptEventContent(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", exploitDetectionLogContent=").append(String.valueOf(this.exploitDetectionLogContent));
        sb.append(", exploitObjectStoreLocation=").append(String.valueOf(this.exploitObjectStoreLocation));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExploitAttemptEventContent)) {
            return false;
        }
        ExploitAttemptEventContent other = (ExploitAttemptEventContent)((Object)o);
        return Objects.equals(this.exploitDetectionLogContent, other.exploitDetectionLogContent) && Objects.equals(this.exploitObjectStoreLocation, other.exploitObjectStoreLocation) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exploitDetectionLogContent == null ? 43 : this.exploitDetectionLogContent.hashCode());
        result = result * 59 + (this.exploitObjectStoreLocation == null ? 43 : this.exploitObjectStoreLocation.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exploitDetectionLogContent")
        private String exploitDetectionLogContent;
        @JsonProperty(value="exploitObjectStoreLocation")
        private String exploitObjectStoreLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exploitDetectionLogContent(String exploitDetectionLogContent) {
            this.exploitDetectionLogContent = exploitDetectionLogContent;
            this.__explicitlySet__.add("exploitDetectionLogContent");
            return this;
        }

        public Builder exploitObjectStoreLocation(String exploitObjectStoreLocation) {
            this.exploitObjectStoreLocation = exploitObjectStoreLocation;
            this.__explicitlySet__.add("exploitObjectStoreLocation");
            return this;
        }

        public ExploitAttemptEventContent build() {
            ExploitAttemptEventContent model = new ExploitAttemptEventContent(this.exploitDetectionLogContent, this.exploitObjectStoreLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExploitAttemptEventContent model) {
            if (model.wasPropertyExplicitlySet("exploitDetectionLogContent")) {
                this.exploitDetectionLogContent(model.getExploitDetectionLogContent());
            }
            if (model.wasPropertyExplicitlySet("exploitObjectStoreLocation")) {
                this.exploitObjectStoreLocation(model.getExploitObjectStoreLocation());
            }
            return this;
        }
    }
}

