/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.EventContent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class KernelEventContent
extends EventContent {
    @JsonProperty(value="contentAvailability")
    private final ContentAvailability contentAvailability;
    @JsonProperty(value="contentLocation")
    private final String contentLocation;
    @JsonProperty(value="size")
    private final Integer size;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public KernelEventContent(ContentAvailability contentAvailability, String contentLocation, Integer size) {
        this.contentAvailability = contentAvailability;
        this.contentLocation = contentLocation;
        this.size = size;
    }

    public ContentAvailability getContentAvailability() {
        return this.contentAvailability;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public Integer getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KernelEventContent(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", contentAvailability=").append(String.valueOf((Object)this.contentAvailability));
        sb.append(", contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KernelEventContent)) {
            return false;
        }
        KernelEventContent other = (KernelEventContent)((Object)o);
        return Objects.equals((Object)this.contentAvailability, (Object)other.contentAvailability) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.size, other.size) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentAvailability == null ? 43 : this.contentAvailability.hashCode());
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        return result;
    }

    public static enum ContentAvailability implements BmcEnum
    {
        NotAvailable("NOT_AVAILABLE"),
        AvailableOnInstance("AVAILABLE_ON_INSTANCE"),
        AvailableOnService("AVAILABLE_ON_SERVICE"),
        AvailableOnInstanceAndService("AVAILABLE_ON_INSTANCE_AND_SERVICE"),
        AvailableOnInstanceUploadInProgress("AVAILABLE_ON_INSTANCE_UPLOAD_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContentAvailability> map;

        private ContentAvailability(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContentAvailability create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContentAvailability', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContentAvailability.class);
            map = new HashMap<String, ContentAvailability>();
            for (ContentAvailability v : ContentAvailability.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="contentAvailability")
        private ContentAvailability contentAvailability;
        @JsonProperty(value="contentLocation")
        private String contentLocation;
        @JsonProperty(value="size")
        private Integer size;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder contentAvailability(ContentAvailability contentAvailability) {
            this.contentAvailability = contentAvailability;
            this.__explicitlySet__.add("contentAvailability");
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            this.__explicitlySet__.add("contentLocation");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public KernelEventContent build() {
            KernelEventContent model = new KernelEventContent(this.contentAvailability, this.contentLocation, this.size);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KernelEventContent model) {
            if (model.wasPropertyExplicitlySet("contentAvailability")) {
                this.contentAvailability(model.getContentAvailability());
            }
            if (model.wasPropertyExplicitlySet("contentLocation")) {
                this.contentLocation(model.getContentLocation());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            return this;
        }
    }
}

