/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.KernelEventAdditionalDetails;
import com.oracle.bmc.osmanagementhub.model.KernelEventContent;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KernelEventData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="content")
    private final KernelEventContent content;
    @JsonProperty(value="count")
    private final Integer count;
    @JsonProperty(value="eventFingerprint")
    private final String eventFingerprint;
    @JsonProperty(value="reason")
    private final String reason;
    @JsonProperty(value="timeFirstOccurred")
    private final Date timeFirstOccurred;
    @JsonProperty(value="additionalDetails")
    private final KernelEventAdditionalDetails additionalDetails;

    @Deprecated
    @ConstructorProperties(value={"content", "count", "eventFingerprint", "reason", "timeFirstOccurred", "additionalDetails"})
    public KernelEventData(KernelEventContent content, Integer count, String eventFingerprint, String reason, Date timeFirstOccurred, KernelEventAdditionalDetails additionalDetails) {
        this.content = content;
        this.count = count;
        this.eventFingerprint = eventFingerprint;
        this.reason = reason;
        this.timeFirstOccurred = timeFirstOccurred;
        this.additionalDetails = additionalDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public KernelEventContent getContent() {
        return this.content;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getEventFingerprint() {
        return this.eventFingerprint;
    }

    public String getReason() {
        return this.reason;
    }

    public Date getTimeFirstOccurred() {
        return this.timeFirstOccurred;
    }

    public KernelEventAdditionalDetails getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KernelEventData(");
        sb.append("super=").append(super.toString());
        sb.append("content=").append(String.valueOf((Object)this.content));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", eventFingerprint=").append(String.valueOf(this.eventFingerprint));
        sb.append(", reason=").append(String.valueOf(this.reason));
        sb.append(", timeFirstOccurred=").append(String.valueOf(this.timeFirstOccurred));
        sb.append(", additionalDetails=").append(String.valueOf((Object)this.additionalDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KernelEventData)) {
            return false;
        }
        KernelEventData other = (KernelEventData)((Object)o);
        return Objects.equals((Object)this.content, (Object)other.content) && Objects.equals(this.count, other.count) && Objects.equals(this.eventFingerprint, other.eventFingerprint) && Objects.equals(this.reason, other.reason) && Objects.equals(this.timeFirstOccurred, other.timeFirstOccurred) && Objects.equals((Object)this.additionalDetails, (Object)other.additionalDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.eventFingerprint == null ? 43 : this.eventFingerprint.hashCode());
        result = result * 59 + (this.reason == null ? 43 : this.reason.hashCode());
        result = result * 59 + (this.timeFirstOccurred == null ? 43 : this.timeFirstOccurred.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="content")
        private KernelEventContent content;
        @JsonProperty(value="count")
        private Integer count;
        @JsonProperty(value="eventFingerprint")
        private String eventFingerprint;
        @JsonProperty(value="reason")
        private String reason;
        @JsonProperty(value="timeFirstOccurred")
        private Date timeFirstOccurred;
        @JsonProperty(value="additionalDetails")
        private KernelEventAdditionalDetails additionalDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder content(KernelEventContent content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder eventFingerprint(String eventFingerprint) {
            this.eventFingerprint = eventFingerprint;
            this.__explicitlySet__.add("eventFingerprint");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.__explicitlySet__.add("reason");
            return this;
        }

        public Builder timeFirstOccurred(Date timeFirstOccurred) {
            this.timeFirstOccurred = timeFirstOccurred;
            this.__explicitlySet__.add("timeFirstOccurred");
            return this;
        }

        public Builder additionalDetails(KernelEventAdditionalDetails additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public KernelEventData build() {
            KernelEventData model = new KernelEventData(this.content, this.count, this.eventFingerprint, this.reason, this.timeFirstOccurred, this.additionalDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KernelEventData model) {
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("eventFingerprint")) {
                this.eventFingerprint(model.getEventFingerprint());
            }
            if (model.wasPropertyExplicitlySet("reason")) {
                this.reason(model.getReason());
            }
            if (model.wasPropertyExplicitlySet("timeFirstOccurred")) {
                this.timeFirstOccurred(model.getTimeFirstOccurred());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            return this;
        }
    }
}

