/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.AutonomousSettings;
import com.oracle.bmc.osmanagementhub.model.Id;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceStatus;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="location")
    private final ManagedInstanceLocation location;
    @JsonProperty(value="timeLastCheckin")
    private final Date timeLastCheckin;
    @JsonProperty(value="timeLastBoot")
    private final Date timeLastBoot;
    @JsonProperty(value="osName")
    private final String osName;
    @JsonProperty(value="osVersion")
    private final String osVersion;
    @JsonProperty(value="osKernelVersion")
    private final String osKernelVersion;
    @JsonProperty(value="kspliceEffectiveKernelVersion")
    private final String kspliceEffectiveKernelVersion;
    @JsonProperty(value="architecture")
    private final ArchType architecture;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="status")
    private final ManagedInstanceStatus status;
    @JsonProperty(value="profile")
    private final String profile;
    @JsonProperty(value="isManagementStation")
    private final Boolean isManagementStation;
    @JsonProperty(value="primaryManagementStationId")
    private final String primaryManagementStationId;
    @JsonProperty(value="secondaryManagementStationId")
    private final String secondaryManagementStationId;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceDetails> softwareSources;
    @JsonProperty(value="managedInstanceGroup")
    private final Id managedInstanceGroup;
    @JsonProperty(value="lifecycleEnvironment")
    private final Id lifecycleEnvironment;
    @JsonProperty(value="lifecycleStage")
    private final Id lifecycleStage;
    @JsonProperty(value="isRebootRequired")
    private final Boolean isRebootRequired;
    @JsonProperty(value="installedPackages")
    private final Integer installedPackages;
    @JsonProperty(value="installedWindowsUpdates")
    private final Integer installedWindowsUpdates;
    @JsonProperty(value="updatesAvailable")
    private final Integer updatesAvailable;
    @JsonProperty(value="securityUpdatesAvailable")
    private final Integer securityUpdatesAvailable;
    @JsonProperty(value="bugUpdatesAvailable")
    private final Integer bugUpdatesAvailable;
    @JsonProperty(value="enhancementUpdatesAvailable")
    private final Integer enhancementUpdatesAvailable;
    @JsonProperty(value="otherUpdatesAvailable")
    private final Integer otherUpdatesAvailable;
    @JsonProperty(value="scheduledJobCount")
    private final Integer scheduledJobCount;
    @JsonProperty(value="workRequestCount")
    private final Integer workRequestCount;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="notificationTopicId")
    private final String notificationTopicId;
    @JsonProperty(value="autonomousSettings")
    private final AutonomousSettings autonomousSettings;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "tenancyId", "compartmentId", "location", "timeLastCheckin", "timeLastBoot", "osName", "osVersion", "osKernelVersion", "kspliceEffectiveKernelVersion", "architecture", "osFamily", "status", "profile", "isManagementStation", "primaryManagementStationId", "secondaryManagementStationId", "softwareSources", "managedInstanceGroup", "lifecycleEnvironment", "lifecycleStage", "isRebootRequired", "installedPackages", "installedWindowsUpdates", "updatesAvailable", "securityUpdatesAvailable", "bugUpdatesAvailable", "enhancementUpdatesAvailable", "otherUpdatesAvailable", "scheduledJobCount", "workRequestCount", "timeCreated", "timeUpdated", "notificationTopicId", "autonomousSettings", "isManagedByAutonomousLinux"})
    public ManagedInstance(String id, String displayName, String description, String tenancyId, String compartmentId, ManagedInstanceLocation location, Date timeLastCheckin, Date timeLastBoot, String osName, String osVersion, String osKernelVersion, String kspliceEffectiveKernelVersion, ArchType architecture, OsFamily osFamily, ManagedInstanceStatus status, String profile, Boolean isManagementStation, String primaryManagementStationId, String secondaryManagementStationId, List<SoftwareSourceDetails> softwareSources, Id managedInstanceGroup, Id lifecycleEnvironment, Id lifecycleStage, Boolean isRebootRequired, Integer installedPackages, Integer installedWindowsUpdates, Integer updatesAvailable, Integer securityUpdatesAvailable, Integer bugUpdatesAvailable, Integer enhancementUpdatesAvailable, Integer otherUpdatesAvailable, Integer scheduledJobCount, Integer workRequestCount, Date timeCreated, Date timeUpdated, String notificationTopicId, AutonomousSettings autonomousSettings, Boolean isManagedByAutonomousLinux) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.tenancyId = tenancyId;
        this.compartmentId = compartmentId;
        this.location = location;
        this.timeLastCheckin = timeLastCheckin;
        this.timeLastBoot = timeLastBoot;
        this.osName = osName;
        this.osVersion = osVersion;
        this.osKernelVersion = osKernelVersion;
        this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
        this.architecture = architecture;
        this.osFamily = osFamily;
        this.status = status;
        this.profile = profile;
        this.isManagementStation = isManagementStation;
        this.primaryManagementStationId = primaryManagementStationId;
        this.secondaryManagementStationId = secondaryManagementStationId;
        this.softwareSources = softwareSources;
        this.managedInstanceGroup = managedInstanceGroup;
        this.lifecycleEnvironment = lifecycleEnvironment;
        this.lifecycleStage = lifecycleStage;
        this.isRebootRequired = isRebootRequired;
        this.installedPackages = installedPackages;
        this.installedWindowsUpdates = installedWindowsUpdates;
        this.updatesAvailable = updatesAvailable;
        this.securityUpdatesAvailable = securityUpdatesAvailable;
        this.bugUpdatesAvailable = bugUpdatesAvailable;
        this.enhancementUpdatesAvailable = enhancementUpdatesAvailable;
        this.otherUpdatesAvailable = otherUpdatesAvailable;
        this.scheduledJobCount = scheduledJobCount;
        this.workRequestCount = workRequestCount;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.notificationTopicId = notificationTopicId;
        this.autonomousSettings = autonomousSettings;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ManagedInstanceLocation getLocation() {
        return this.location;
    }

    public Date getTimeLastCheckin() {
        return this.timeLastCheckin;
    }

    public Date getTimeLastBoot() {
        return this.timeLastBoot;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsKernelVersion() {
        return this.osKernelVersion;
    }

    public String getKspliceEffectiveKernelVersion() {
        return this.kspliceEffectiveKernelVersion;
    }

    public ArchType getArchitecture() {
        return this.architecture;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ManagedInstanceStatus getStatus() {
        return this.status;
    }

    public String getProfile() {
        return this.profile;
    }

    public Boolean getIsManagementStation() {
        return this.isManagementStation;
    }

    public String getPrimaryManagementStationId() {
        return this.primaryManagementStationId;
    }

    public String getSecondaryManagementStationId() {
        return this.secondaryManagementStationId;
    }

    public List<SoftwareSourceDetails> getSoftwareSources() {
        return this.softwareSources;
    }

    public Id getManagedInstanceGroup() {
        return this.managedInstanceGroup;
    }

    public Id getLifecycleEnvironment() {
        return this.lifecycleEnvironment;
    }

    public Id getLifecycleStage() {
        return this.lifecycleStage;
    }

    public Boolean getIsRebootRequired() {
        return this.isRebootRequired;
    }

    public Integer getInstalledPackages() {
        return this.installedPackages;
    }

    public Integer getInstalledWindowsUpdates() {
        return this.installedWindowsUpdates;
    }

    public Integer getUpdatesAvailable() {
        return this.updatesAvailable;
    }

    public Integer getSecurityUpdatesAvailable() {
        return this.securityUpdatesAvailable;
    }

    public Integer getBugUpdatesAvailable() {
        return this.bugUpdatesAvailable;
    }

    public Integer getEnhancementUpdatesAvailable() {
        return this.enhancementUpdatesAvailable;
    }

    public Integer getOtherUpdatesAvailable() {
        return this.otherUpdatesAvailable;
    }

    public Integer getScheduledJobCount() {
        return this.scheduledJobCount;
    }

    public Integer getWorkRequestCount() {
        return this.workRequestCount;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getNotificationTopicId() {
        return this.notificationTopicId;
    }

    public AutonomousSettings getAutonomousSettings() {
        return this.autonomousSettings;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", location=").append(String.valueOf((Object)this.location));
        sb.append(", timeLastCheckin=").append(String.valueOf(this.timeLastCheckin));
        sb.append(", timeLastBoot=").append(String.valueOf(this.timeLastBoot));
        sb.append(", osName=").append(String.valueOf(this.osName));
        sb.append(", osVersion=").append(String.valueOf(this.osVersion));
        sb.append(", osKernelVersion=").append(String.valueOf(this.osKernelVersion));
        sb.append(", kspliceEffectiveKernelVersion=").append(String.valueOf(this.kspliceEffectiveKernelVersion));
        sb.append(", architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", profile=").append(String.valueOf(this.profile));
        sb.append(", isManagementStation=").append(String.valueOf(this.isManagementStation));
        sb.append(", primaryManagementStationId=").append(String.valueOf(this.primaryManagementStationId));
        sb.append(", secondaryManagementStationId=").append(String.valueOf(this.secondaryManagementStationId));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(", managedInstanceGroup=").append(String.valueOf((Object)this.managedInstanceGroup));
        sb.append(", lifecycleEnvironment=").append(String.valueOf((Object)this.lifecycleEnvironment));
        sb.append(", lifecycleStage=").append(String.valueOf((Object)this.lifecycleStage));
        sb.append(", isRebootRequired=").append(String.valueOf(this.isRebootRequired));
        sb.append(", installedPackages=").append(String.valueOf(this.installedPackages));
        sb.append(", installedWindowsUpdates=").append(String.valueOf(this.installedWindowsUpdates));
        sb.append(", updatesAvailable=").append(String.valueOf(this.updatesAvailable));
        sb.append(", securityUpdatesAvailable=").append(String.valueOf(this.securityUpdatesAvailable));
        sb.append(", bugUpdatesAvailable=").append(String.valueOf(this.bugUpdatesAvailable));
        sb.append(", enhancementUpdatesAvailable=").append(String.valueOf(this.enhancementUpdatesAvailable));
        sb.append(", otherUpdatesAvailable=").append(String.valueOf(this.otherUpdatesAvailable));
        sb.append(", scheduledJobCount=").append(String.valueOf(this.scheduledJobCount));
        sb.append(", workRequestCount=").append(String.valueOf(this.workRequestCount));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", notificationTopicId=").append(String.valueOf(this.notificationTopicId));
        sb.append(", autonomousSettings=").append(String.valueOf((Object)this.autonomousSettings));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstance)) {
            return false;
        }
        ManagedInstance other = (ManagedInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.location, (Object)other.location) && Objects.equals(this.timeLastCheckin, other.timeLastCheckin) && Objects.equals(this.timeLastBoot, other.timeLastBoot) && Objects.equals(this.osName, other.osName) && Objects.equals(this.osVersion, other.osVersion) && Objects.equals(this.osKernelVersion, other.osKernelVersion) && Objects.equals(this.kspliceEffectiveKernelVersion, other.kspliceEffectiveKernelVersion) && Objects.equals((Object)this.architecture, (Object)other.architecture) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.profile, other.profile) && Objects.equals(this.isManagementStation, other.isManagementStation) && Objects.equals(this.primaryManagementStationId, other.primaryManagementStationId) && Objects.equals(this.secondaryManagementStationId, other.secondaryManagementStationId) && Objects.equals(this.softwareSources, other.softwareSources) && Objects.equals((Object)this.managedInstanceGroup, (Object)other.managedInstanceGroup) && Objects.equals((Object)this.lifecycleEnvironment, (Object)other.lifecycleEnvironment) && Objects.equals((Object)this.lifecycleStage, (Object)other.lifecycleStage) && Objects.equals(this.isRebootRequired, other.isRebootRequired) && Objects.equals(this.installedPackages, other.installedPackages) && Objects.equals(this.installedWindowsUpdates, other.installedWindowsUpdates) && Objects.equals(this.updatesAvailable, other.updatesAvailable) && Objects.equals(this.securityUpdatesAvailable, other.securityUpdatesAvailable) && Objects.equals(this.bugUpdatesAvailable, other.bugUpdatesAvailable) && Objects.equals(this.enhancementUpdatesAvailable, other.enhancementUpdatesAvailable) && Objects.equals(this.otherUpdatesAvailable, other.otherUpdatesAvailable) && Objects.equals(this.scheduledJobCount, other.scheduledJobCount) && Objects.equals(this.workRequestCount, other.workRequestCount) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.notificationTopicId, other.notificationTopicId) && Objects.equals((Object)this.autonomousSettings, (Object)other.autonomousSettings) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.timeLastCheckin == null ? 43 : this.timeLastCheckin.hashCode());
        result = result * 59 + (this.timeLastBoot == null ? 43 : this.timeLastBoot.hashCode());
        result = result * 59 + (this.osName == null ? 43 : this.osName.hashCode());
        result = result * 59 + (this.osVersion == null ? 43 : this.osVersion.hashCode());
        result = result * 59 + (this.osKernelVersion == null ? 43 : this.osKernelVersion.hashCode());
        result = result * 59 + (this.kspliceEffectiveKernelVersion == null ? 43 : this.kspliceEffectiveKernelVersion.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.profile == null ? 43 : this.profile.hashCode());
        result = result * 59 + (this.isManagementStation == null ? 43 : this.isManagementStation.hashCode());
        result = result * 59 + (this.primaryManagementStationId == null ? 43 : this.primaryManagementStationId.hashCode());
        result = result * 59 + (this.secondaryManagementStationId == null ? 43 : this.secondaryManagementStationId.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + (this.managedInstanceGroup == null ? 43 : this.managedInstanceGroup.hashCode());
        result = result * 59 + (this.lifecycleEnvironment == null ? 43 : this.lifecycleEnvironment.hashCode());
        result = result * 59 + (this.lifecycleStage == null ? 43 : this.lifecycleStage.hashCode());
        result = result * 59 + (this.isRebootRequired == null ? 43 : this.isRebootRequired.hashCode());
        result = result * 59 + (this.installedPackages == null ? 43 : this.installedPackages.hashCode());
        result = result * 59 + (this.installedWindowsUpdates == null ? 43 : this.installedWindowsUpdates.hashCode());
        result = result * 59 + (this.updatesAvailable == null ? 43 : this.updatesAvailable.hashCode());
        result = result * 59 + (this.securityUpdatesAvailable == null ? 43 : this.securityUpdatesAvailable.hashCode());
        result = result * 59 + (this.bugUpdatesAvailable == null ? 43 : this.bugUpdatesAvailable.hashCode());
        result = result * 59 + (this.enhancementUpdatesAvailable == null ? 43 : this.enhancementUpdatesAvailable.hashCode());
        result = result * 59 + (this.otherUpdatesAvailable == null ? 43 : this.otherUpdatesAvailable.hashCode());
        result = result * 59 + (this.scheduledJobCount == null ? 43 : this.scheduledJobCount.hashCode());
        result = result * 59 + (this.workRequestCount == null ? 43 : this.workRequestCount.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.notificationTopicId == null ? 43 : this.notificationTopicId.hashCode());
        result = result * 59 + (this.autonomousSettings == null ? 43 : this.autonomousSettings.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="location")
        private ManagedInstanceLocation location;
        @JsonProperty(value="timeLastCheckin")
        private Date timeLastCheckin;
        @JsonProperty(value="timeLastBoot")
        private Date timeLastBoot;
        @JsonProperty(value="osName")
        private String osName;
        @JsonProperty(value="osVersion")
        private String osVersion;
        @JsonProperty(value="osKernelVersion")
        private String osKernelVersion;
        @JsonProperty(value="kspliceEffectiveKernelVersion")
        private String kspliceEffectiveKernelVersion;
        @JsonProperty(value="architecture")
        private ArchType architecture;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="status")
        private ManagedInstanceStatus status;
        @JsonProperty(value="profile")
        private String profile;
        @JsonProperty(value="isManagementStation")
        private Boolean isManagementStation;
        @JsonProperty(value="primaryManagementStationId")
        private String primaryManagementStationId;
        @JsonProperty(value="secondaryManagementStationId")
        private String secondaryManagementStationId;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceDetails> softwareSources;
        @JsonProperty(value="managedInstanceGroup")
        private Id managedInstanceGroup;
        @JsonProperty(value="lifecycleEnvironment")
        private Id lifecycleEnvironment;
        @JsonProperty(value="lifecycleStage")
        private Id lifecycleStage;
        @JsonProperty(value="isRebootRequired")
        private Boolean isRebootRequired;
        @JsonProperty(value="installedPackages")
        private Integer installedPackages;
        @JsonProperty(value="installedWindowsUpdates")
        private Integer installedWindowsUpdates;
        @JsonProperty(value="updatesAvailable")
        private Integer updatesAvailable;
        @JsonProperty(value="securityUpdatesAvailable")
        private Integer securityUpdatesAvailable;
        @JsonProperty(value="bugUpdatesAvailable")
        private Integer bugUpdatesAvailable;
        @JsonProperty(value="enhancementUpdatesAvailable")
        private Integer enhancementUpdatesAvailable;
        @JsonProperty(value="otherUpdatesAvailable")
        private Integer otherUpdatesAvailable;
        @JsonProperty(value="scheduledJobCount")
        private Integer scheduledJobCount;
        @JsonProperty(value="workRequestCount")
        private Integer workRequestCount;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="notificationTopicId")
        private String notificationTopicId;
        @JsonProperty(value="autonomousSettings")
        private AutonomousSettings autonomousSettings;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder location(ManagedInstanceLocation location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder timeLastCheckin(Date timeLastCheckin) {
            this.timeLastCheckin = timeLastCheckin;
            this.__explicitlySet__.add("timeLastCheckin");
            return this;
        }

        public Builder timeLastBoot(Date timeLastBoot) {
            this.timeLastBoot = timeLastBoot;
            this.__explicitlySet__.add("timeLastBoot");
            return this;
        }

        public Builder osName(String osName) {
            this.osName = osName;
            this.__explicitlySet__.add("osName");
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            this.__explicitlySet__.add("osVersion");
            return this;
        }

        public Builder osKernelVersion(String osKernelVersion) {
            this.osKernelVersion = osKernelVersion;
            this.__explicitlySet__.add("osKernelVersion");
            return this;
        }

        public Builder kspliceEffectiveKernelVersion(String kspliceEffectiveKernelVersion) {
            this.kspliceEffectiveKernelVersion = kspliceEffectiveKernelVersion;
            this.__explicitlySet__.add("kspliceEffectiveKernelVersion");
            return this;
        }

        public Builder architecture(ArchType architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder status(ManagedInstanceStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            this.__explicitlySet__.add("profile");
            return this;
        }

        public Builder isManagementStation(Boolean isManagementStation) {
            this.isManagementStation = isManagementStation;
            this.__explicitlySet__.add("isManagementStation");
            return this;
        }

        public Builder primaryManagementStationId(String primaryManagementStationId) {
            this.primaryManagementStationId = primaryManagementStationId;
            this.__explicitlySet__.add("primaryManagementStationId");
            return this;
        }

        public Builder secondaryManagementStationId(String secondaryManagementStationId) {
            this.secondaryManagementStationId = secondaryManagementStationId;
            this.__explicitlySet__.add("secondaryManagementStationId");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceDetails> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public Builder managedInstanceGroup(Id managedInstanceGroup) {
            this.managedInstanceGroup = managedInstanceGroup;
            this.__explicitlySet__.add("managedInstanceGroup");
            return this;
        }

        public Builder lifecycleEnvironment(Id lifecycleEnvironment) {
            this.lifecycleEnvironment = lifecycleEnvironment;
            this.__explicitlySet__.add("lifecycleEnvironment");
            return this;
        }

        public Builder lifecycleStage(Id lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            this.__explicitlySet__.add("lifecycleStage");
            return this;
        }

        public Builder isRebootRequired(Boolean isRebootRequired) {
            this.isRebootRequired = isRebootRequired;
            this.__explicitlySet__.add("isRebootRequired");
            return this;
        }

        public Builder installedPackages(Integer installedPackages) {
            this.installedPackages = installedPackages;
            this.__explicitlySet__.add("installedPackages");
            return this;
        }

        public Builder installedWindowsUpdates(Integer installedWindowsUpdates) {
            this.installedWindowsUpdates = installedWindowsUpdates;
            this.__explicitlySet__.add("installedWindowsUpdates");
            return this;
        }

        public Builder updatesAvailable(Integer updatesAvailable) {
            this.updatesAvailable = updatesAvailable;
            this.__explicitlySet__.add("updatesAvailable");
            return this;
        }

        public Builder securityUpdatesAvailable(Integer securityUpdatesAvailable) {
            this.securityUpdatesAvailable = securityUpdatesAvailable;
            this.__explicitlySet__.add("securityUpdatesAvailable");
            return this;
        }

        public Builder bugUpdatesAvailable(Integer bugUpdatesAvailable) {
            this.bugUpdatesAvailable = bugUpdatesAvailable;
            this.__explicitlySet__.add("bugUpdatesAvailable");
            return this;
        }

        public Builder enhancementUpdatesAvailable(Integer enhancementUpdatesAvailable) {
            this.enhancementUpdatesAvailable = enhancementUpdatesAvailable;
            this.__explicitlySet__.add("enhancementUpdatesAvailable");
            return this;
        }

        public Builder otherUpdatesAvailable(Integer otherUpdatesAvailable) {
            this.otherUpdatesAvailable = otherUpdatesAvailable;
            this.__explicitlySet__.add("otherUpdatesAvailable");
            return this;
        }

        public Builder scheduledJobCount(Integer scheduledJobCount) {
            this.scheduledJobCount = scheduledJobCount;
            this.__explicitlySet__.add("scheduledJobCount");
            return this;
        }

        public Builder workRequestCount(Integer workRequestCount) {
            this.workRequestCount = workRequestCount;
            this.__explicitlySet__.add("workRequestCount");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder notificationTopicId(String notificationTopicId) {
            this.notificationTopicId = notificationTopicId;
            this.__explicitlySet__.add("notificationTopicId");
            return this;
        }

        public Builder autonomousSettings(AutonomousSettings autonomousSettings) {
            this.autonomousSettings = autonomousSettings;
            this.__explicitlySet__.add("autonomousSettings");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public ManagedInstance build() {
            ManagedInstance model = new ManagedInstance(this.id, this.displayName, this.description, this.tenancyId, this.compartmentId, this.location, this.timeLastCheckin, this.timeLastBoot, this.osName, this.osVersion, this.osKernelVersion, this.kspliceEffectiveKernelVersion, this.architecture, this.osFamily, this.status, this.profile, this.isManagementStation, this.primaryManagementStationId, this.secondaryManagementStationId, this.softwareSources, this.managedInstanceGroup, this.lifecycleEnvironment, this.lifecycleStage, this.isRebootRequired, this.installedPackages, this.installedWindowsUpdates, this.updatesAvailable, this.securityUpdatesAvailable, this.bugUpdatesAvailable, this.enhancementUpdatesAvailable, this.otherUpdatesAvailable, this.scheduledJobCount, this.workRequestCount, this.timeCreated, this.timeUpdated, this.notificationTopicId, this.autonomousSettings, this.isManagedByAutonomousLinux);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("timeLastCheckin")) {
                this.timeLastCheckin(model.getTimeLastCheckin());
            }
            if (model.wasPropertyExplicitlySet("timeLastBoot")) {
                this.timeLastBoot(model.getTimeLastBoot());
            }
            if (model.wasPropertyExplicitlySet("osName")) {
                this.osName(model.getOsName());
            }
            if (model.wasPropertyExplicitlySet("osVersion")) {
                this.osVersion(model.getOsVersion());
            }
            if (model.wasPropertyExplicitlySet("osKernelVersion")) {
                this.osKernelVersion(model.getOsKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("kspliceEffectiveKernelVersion")) {
                this.kspliceEffectiveKernelVersion(model.getKspliceEffectiveKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("profile")) {
                this.profile(model.getProfile());
            }
            if (model.wasPropertyExplicitlySet("isManagementStation")) {
                this.isManagementStation(model.getIsManagementStation());
            }
            if (model.wasPropertyExplicitlySet("primaryManagementStationId")) {
                this.primaryManagementStationId(model.getPrimaryManagementStationId());
            }
            if (model.wasPropertyExplicitlySet("secondaryManagementStationId")) {
                this.secondaryManagementStationId(model.getSecondaryManagementStationId());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceGroup")) {
                this.managedInstanceGroup(model.getManagedInstanceGroup());
            }
            if (model.wasPropertyExplicitlySet("lifecycleEnvironment")) {
                this.lifecycleEnvironment(model.getLifecycleEnvironment());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStage")) {
                this.lifecycleStage(model.getLifecycleStage());
            }
            if (model.wasPropertyExplicitlySet("isRebootRequired")) {
                this.isRebootRequired(model.getIsRebootRequired());
            }
            if (model.wasPropertyExplicitlySet("installedPackages")) {
                this.installedPackages(model.getInstalledPackages());
            }
            if (model.wasPropertyExplicitlySet("installedWindowsUpdates")) {
                this.installedWindowsUpdates(model.getInstalledWindowsUpdates());
            }
            if (model.wasPropertyExplicitlySet("updatesAvailable")) {
                this.updatesAvailable(model.getUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("securityUpdatesAvailable")) {
                this.securityUpdatesAvailable(model.getSecurityUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("bugUpdatesAvailable")) {
                this.bugUpdatesAvailable(model.getBugUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("enhancementUpdatesAvailable")) {
                this.enhancementUpdatesAvailable(model.getEnhancementUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("otherUpdatesAvailable")) {
                this.otherUpdatesAvailable(model.getOtherUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("scheduledJobCount")) {
                this.scheduledJobCount(model.getScheduledJobCount());
            }
            if (model.wasPropertyExplicitlySet("workRequestCount")) {
                this.workRequestCount(model.getWorkRequestCount());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("notificationTopicId")) {
                this.notificationTopicId(model.getNotificationTopicId());
            }
            if (model.wasPropertyExplicitlySet("autonomousSettings")) {
                this.autonomousSettings(model.getAutonomousSettings());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            return this;
        }
    }
}

