/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.PackageNameSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceErratumSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="advisoryType")
    private final ClassificationTypes advisoryType;
    @JsonProperty(value="timeIssued")
    private final Date timeIssued;
    @JsonProperty(value="synopsis")
    private final String synopsis;
    @JsonProperty(value="relatedCves")
    private final List<String> relatedCves;
    @JsonProperty(value="packages")
    private final List<PackageNameSummary> packages;

    @Deprecated
    @ConstructorProperties(value={"name", "advisoryType", "timeIssued", "synopsis", "relatedCves", "packages"})
    public ManagedInstanceErratumSummary(String name, ClassificationTypes advisoryType, Date timeIssued, String synopsis, List<String> relatedCves, List<PackageNameSummary> packages) {
        this.name = name;
        this.advisoryType = advisoryType;
        this.timeIssued = timeIssued;
        this.synopsis = synopsis;
        this.relatedCves = relatedCves;
        this.packages = packages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public ClassificationTypes getAdvisoryType() {
        return this.advisoryType;
    }

    public Date getTimeIssued() {
        return this.timeIssued;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public List<String> getRelatedCves() {
        return this.relatedCves;
    }

    public List<PackageNameSummary> getPackages() {
        return this.packages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceErratumSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", advisoryType=").append(String.valueOf((Object)this.advisoryType));
        sb.append(", timeIssued=").append(String.valueOf(this.timeIssued));
        sb.append(", synopsis=").append(String.valueOf(this.synopsis));
        sb.append(", relatedCves=").append(String.valueOf(this.relatedCves));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceErratumSummary)) {
            return false;
        }
        ManagedInstanceErratumSummary other = (ManagedInstanceErratumSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.advisoryType, (Object)other.advisoryType) && Objects.equals(this.timeIssued, other.timeIssued) && Objects.equals(this.synopsis, other.synopsis) && Objects.equals(this.relatedCves, other.relatedCves) && Objects.equals(this.packages, other.packages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + (this.timeIssued == null ? 43 : this.timeIssued.hashCode());
        result = result * 59 + (this.synopsis == null ? 43 : this.synopsis.hashCode());
        result = result * 59 + (this.relatedCves == null ? 43 : this.relatedCves.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="advisoryType")
        private ClassificationTypes advisoryType;
        @JsonProperty(value="timeIssued")
        private Date timeIssued;
        @JsonProperty(value="synopsis")
        private String synopsis;
        @JsonProperty(value="relatedCves")
        private List<String> relatedCves;
        @JsonProperty(value="packages")
        private List<PackageNameSummary> packages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder advisoryType(ClassificationTypes advisoryType) {
            this.advisoryType = advisoryType;
            this.__explicitlySet__.add("advisoryType");
            return this;
        }

        public Builder timeIssued(Date timeIssued) {
            this.timeIssued = timeIssued;
            this.__explicitlySet__.add("timeIssued");
            return this;
        }

        public Builder synopsis(String synopsis) {
            this.synopsis = synopsis;
            this.__explicitlySet__.add("synopsis");
            return this;
        }

        public Builder relatedCves(List<String> relatedCves) {
            this.relatedCves = relatedCves;
            this.__explicitlySet__.add("relatedCves");
            return this;
        }

        public Builder packages(List<PackageNameSummary> packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public ManagedInstanceErratumSummary build() {
            ManagedInstanceErratumSummary model = new ManagedInstanceErratumSummary(this.name, this.advisoryType, this.timeIssued, this.synopsis, this.relatedCves, this.packages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceErratumSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("advisoryType")) {
                this.advisoryType(model.getAdvisoryType());
            }
            if (model.wasPropertyExplicitlySet("timeIssued")) {
                this.timeIssued(model.getTimeIssued());
            }
            if (model.wasPropertyExplicitlySet("synopsis")) {
                this.synopsis(model.getSynopsis());
            }
            if (model.wasPropertyExplicitlySet("relatedCves")) {
                this.relatedCves(model.getRelatedCves());
            }
            if (model.wasPropertyExplicitlySet("packages")) {
                this.packages(model.getPackages());
            }
            return this;
        }
    }
}

