/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.AutonomousSettings;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceDetails;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceGroup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeModified")
    private final Date timeModified;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="archType")
    private final ArchType archType;
    @JsonProperty(value="vendorName")
    private final VendorName vendorName;
    @JsonProperty(value="softwareSourceIds")
    private final List<SoftwareSourceDetails> softwareSourceIds;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceDetails> softwareSources;
    @JsonProperty(value="managedInstanceIds")
    private final List<String> managedInstanceIds;
    @JsonProperty(value="managedInstanceCount")
    private final Integer managedInstanceCount;
    @JsonProperty(value="location")
    private final ManagedInstanceLocation location;
    @JsonProperty(value="pendingJobCount")
    private final Integer pendingJobCount;
    @JsonProperty(value="notificationTopicId")
    private final String notificationTopicId;
    @JsonProperty(value="autonomousSettings")
    private final AutonomousSettings autonomousSettings;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "timeCreated", "timeModified", "lifecycleState", "osFamily", "archType", "vendorName", "softwareSourceIds", "softwareSources", "managedInstanceIds", "managedInstanceCount", "location", "pendingJobCount", "notificationTopicId", "autonomousSettings", "isManagedByAutonomousLinux", "freeformTags", "definedTags", "systemTags"})
    public ManagedInstanceGroup(String id, String compartmentId, String displayName, String description, Date timeCreated, Date timeModified, LifecycleState lifecycleState, OsFamily osFamily, ArchType archType, VendorName vendorName, List<SoftwareSourceDetails> softwareSourceIds, List<SoftwareSourceDetails> softwareSources, List<String> managedInstanceIds, Integer managedInstanceCount, ManagedInstanceLocation location, Integer pendingJobCount, String notificationTopicId, AutonomousSettings autonomousSettings, Boolean isManagedByAutonomousLinux, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.timeCreated = timeCreated;
        this.timeModified = timeModified;
        this.lifecycleState = lifecycleState;
        this.osFamily = osFamily;
        this.archType = archType;
        this.vendorName = vendorName;
        this.softwareSourceIds = softwareSourceIds;
        this.softwareSources = softwareSources;
        this.managedInstanceIds = managedInstanceIds;
        this.managedInstanceCount = managedInstanceCount;
        this.location = location;
        this.pendingJobCount = pendingJobCount;
        this.notificationTopicId = notificationTopicId;
        this.autonomousSettings = autonomousSettings;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeModified() {
        return this.timeModified;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ArchType getArchType() {
        return this.archType;
    }

    public VendorName getVendorName() {
        return this.vendorName;
    }

    public List<SoftwareSourceDetails> getSoftwareSourceIds() {
        return this.softwareSourceIds;
    }

    public List<SoftwareSourceDetails> getSoftwareSources() {
        return this.softwareSources;
    }

    public List<String> getManagedInstanceIds() {
        return this.managedInstanceIds;
    }

    public Integer getManagedInstanceCount() {
        return this.managedInstanceCount;
    }

    public ManagedInstanceLocation getLocation() {
        return this.location;
    }

    public Integer getPendingJobCount() {
        return this.pendingJobCount;
    }

    public String getNotificationTopicId() {
        return this.notificationTopicId;
    }

    public AutonomousSettings getAutonomousSettings() {
        return this.autonomousSettings;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceGroup(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeModified=").append(String.valueOf(this.timeModified));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", archType=").append(String.valueOf((Object)this.archType));
        sb.append(", vendorName=").append(String.valueOf((Object)this.vendorName));
        sb.append(", softwareSourceIds=").append(String.valueOf(this.softwareSourceIds));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(", managedInstanceIds=").append(String.valueOf(this.managedInstanceIds));
        sb.append(", managedInstanceCount=").append(String.valueOf(this.managedInstanceCount));
        sb.append(", location=").append(String.valueOf((Object)this.location));
        sb.append(", pendingJobCount=").append(String.valueOf(this.pendingJobCount));
        sb.append(", notificationTopicId=").append(String.valueOf(this.notificationTopicId));
        sb.append(", autonomousSettings=").append(String.valueOf((Object)this.autonomousSettings));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceGroup)) {
            return false;
        }
        ManagedInstanceGroup other = (ManagedInstanceGroup)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeModified, other.timeModified) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals((Object)this.vendorName, (Object)other.vendorName) && Objects.equals(this.softwareSourceIds, other.softwareSourceIds) && Objects.equals(this.softwareSources, other.softwareSources) && Objects.equals(this.managedInstanceIds, other.managedInstanceIds) && Objects.equals(this.managedInstanceCount, other.managedInstanceCount) && Objects.equals((Object)this.location, (Object)other.location) && Objects.equals(this.pendingJobCount, other.pendingJobCount) && Objects.equals(this.notificationTopicId, other.notificationTopicId) && Objects.equals((Object)this.autonomousSettings, (Object)other.autonomousSettings) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeModified == null ? 43 : this.timeModified.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.softwareSourceIds == null ? 43 : this.softwareSourceIds.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + (this.managedInstanceIds == null ? 43 : this.managedInstanceIds.hashCode());
        result = result * 59 + (this.managedInstanceCount == null ? 43 : this.managedInstanceCount.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.pendingJobCount == null ? 43 : this.pendingJobCount.hashCode());
        result = result * 59 + (this.notificationTopicId == null ? 43 : this.notificationTopicId.hashCode());
        result = result * 59 + (this.autonomousSettings == null ? 43 : this.autonomousSettings.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeModified")
        private Date timeModified;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="archType")
        private ArchType archType;
        @JsonProperty(value="vendorName")
        private VendorName vendorName;
        @JsonProperty(value="softwareSourceIds")
        private List<SoftwareSourceDetails> softwareSourceIds;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceDetails> softwareSources;
        @JsonProperty(value="managedInstanceIds")
        private List<String> managedInstanceIds;
        @JsonProperty(value="managedInstanceCount")
        private Integer managedInstanceCount;
        @JsonProperty(value="location")
        private ManagedInstanceLocation location;
        @JsonProperty(value="pendingJobCount")
        private Integer pendingJobCount;
        @JsonProperty(value="notificationTopicId")
        private String notificationTopicId;
        @JsonProperty(value="autonomousSettings")
        private AutonomousSettings autonomousSettings;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeModified(Date timeModified) {
            this.timeModified = timeModified;
            this.__explicitlySet__.add("timeModified");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder archType(ArchType archType) {
            this.archType = archType;
            this.__explicitlySet__.add("archType");
            return this;
        }

        public Builder vendorName(VendorName vendorName) {
            this.vendorName = vendorName;
            this.__explicitlySet__.add("vendorName");
            return this;
        }

        public Builder softwareSourceIds(List<SoftwareSourceDetails> softwareSourceIds) {
            this.softwareSourceIds = softwareSourceIds;
            this.__explicitlySet__.add("softwareSourceIds");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceDetails> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public Builder managedInstanceIds(List<String> managedInstanceIds) {
            this.managedInstanceIds = managedInstanceIds;
            this.__explicitlySet__.add("managedInstanceIds");
            return this;
        }

        public Builder managedInstanceCount(Integer managedInstanceCount) {
            this.managedInstanceCount = managedInstanceCount;
            this.__explicitlySet__.add("managedInstanceCount");
            return this;
        }

        public Builder location(ManagedInstanceLocation location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder pendingJobCount(Integer pendingJobCount) {
            this.pendingJobCount = pendingJobCount;
            this.__explicitlySet__.add("pendingJobCount");
            return this;
        }

        public Builder notificationTopicId(String notificationTopicId) {
            this.notificationTopicId = notificationTopicId;
            this.__explicitlySet__.add("notificationTopicId");
            return this;
        }

        public Builder autonomousSettings(AutonomousSettings autonomousSettings) {
            this.autonomousSettings = autonomousSettings;
            this.__explicitlySet__.add("autonomousSettings");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ManagedInstanceGroup build() {
            ManagedInstanceGroup model = new ManagedInstanceGroup(this.id, this.compartmentId, this.displayName, this.description, this.timeCreated, this.timeModified, this.lifecycleState, this.osFamily, this.archType, this.vendorName, this.softwareSourceIds, this.softwareSources, this.managedInstanceIds, this.managedInstanceCount, this.location, this.pendingJobCount, this.notificationTopicId, this.autonomousSettings, this.isManagedByAutonomousLinux, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceGroup model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeModified")) {
                this.timeModified(model.getTimeModified());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("archType")) {
                this.archType(model.getArchType());
            }
            if (model.wasPropertyExplicitlySet("vendorName")) {
                this.vendorName(model.getVendorName());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceIds")) {
                this.softwareSourceIds(model.getSoftwareSourceIds());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceIds")) {
                this.managedInstanceIds(model.getManagedInstanceIds());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceCount")) {
                this.managedInstanceCount(model.getManagedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("pendingJobCount")) {
                this.pendingJobCount(model.getPendingJobCount());
            }
            if (model.wasPropertyExplicitlySet("notificationTopicId")) {
                this.notificationTopicId(model.getNotificationTopicId());
            }
            if (model.wasPropertyExplicitlySet("autonomousSettings")) {
                this.autonomousSettings(model.getAutonomousSettings());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

