/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceGroupAvailablePackageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="architecture")
    private final ArchType architecture;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceDetails> softwareSources;
    @JsonProperty(value="isLatest")
    private final Boolean isLatest;

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "type", "version", "architecture", "softwareSources", "isLatest"})
    public ManagedInstanceGroupAvailablePackageSummary(String displayName, String name, String type, String version, ArchType architecture, List<SoftwareSourceDetails> softwareSources, Boolean isLatest) {
        this.displayName = displayName;
        this.name = name;
        this.type = type;
        this.version = version;
        this.architecture = architecture;
        this.softwareSources = softwareSources;
        this.isLatest = isLatest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public ArchType getArchitecture() {
        return this.architecture;
    }

    public List<SoftwareSourceDetails> getSoftwareSources() {
        return this.softwareSources;
    }

    public Boolean getIsLatest() {
        return this.isLatest;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceGroupAvailablePackageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(", isLatest=").append(String.valueOf(this.isLatest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceGroupAvailablePackageSummary)) {
            return false;
        }
        ManagedInstanceGroupAvailablePackageSummary other = (ManagedInstanceGroupAvailablePackageSummary)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.architecture, (Object)other.architecture) && Objects.equals(this.softwareSources, other.softwareSources) && Objects.equals(this.isLatest, other.isLatest) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + (this.isLatest == null ? 43 : this.isLatest.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="architecture")
        private ArchType architecture;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceDetails> softwareSources;
        @JsonProperty(value="isLatest")
        private Boolean isLatest;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder architecture(ArchType architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceDetails> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            this.__explicitlySet__.add("isLatest");
            return this;
        }

        public ManagedInstanceGroupAvailablePackageSummary build() {
            ManagedInstanceGroupAvailablePackageSummary model = new ManagedInstanceGroupAvailablePackageSummary(this.displayName, this.name, this.type, this.version, this.architecture, this.softwareSources, this.isLatest);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceGroupAvailablePackageSummary model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("isLatest")) {
                this.isLatest(model.getIsLatest());
            }
            return this;
        }
    }
}

