/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceModuleSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="enabledStream")
    private final String enabledStream;
    @JsonProperty(value="installedProfiles")
    private final List<String> installedProfiles;
    @JsonProperty(value="activeStreams")
    private final List<String> activeStreams;
    @JsonProperty(value="disabledStreams")
    private final List<String> disabledStreams;
    @JsonProperty(value="softwareSourceId")
    private final String softwareSourceId;

    @Deprecated
    @ConstructorProperties(value={"name", "enabledStream", "installedProfiles", "activeStreams", "disabledStreams", "softwareSourceId"})
    public ManagedInstanceModuleSummary(String name, String enabledStream, List<String> installedProfiles, List<String> activeStreams, List<String> disabledStreams, String softwareSourceId) {
        this.name = name;
        this.enabledStream = enabledStream;
        this.installedProfiles = installedProfiles;
        this.activeStreams = activeStreams;
        this.disabledStreams = disabledStreams;
        this.softwareSourceId = softwareSourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getEnabledStream() {
        return this.enabledStream;
    }

    public List<String> getInstalledProfiles() {
        return this.installedProfiles;
    }

    public List<String> getActiveStreams() {
        return this.activeStreams;
    }

    public List<String> getDisabledStreams() {
        return this.disabledStreams;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceModuleSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", enabledStream=").append(String.valueOf(this.enabledStream));
        sb.append(", installedProfiles=").append(String.valueOf(this.installedProfiles));
        sb.append(", activeStreams=").append(String.valueOf(this.activeStreams));
        sb.append(", disabledStreams=").append(String.valueOf(this.disabledStreams));
        sb.append(", softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceModuleSummary)) {
            return false;
        }
        ManagedInstanceModuleSummary other = (ManagedInstanceModuleSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.enabledStream, other.enabledStream) && Objects.equals(this.installedProfiles, other.installedProfiles) && Objects.equals(this.activeStreams, other.activeStreams) && Objects.equals(this.disabledStreams, other.disabledStreams) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.enabledStream == null ? 43 : this.enabledStream.hashCode());
        result = result * 59 + (this.installedProfiles == null ? 43 : this.installedProfiles.hashCode());
        result = result * 59 + (this.activeStreams == null ? 43 : this.activeStreams.hashCode());
        result = result * 59 + (this.disabledStreams == null ? 43 : this.disabledStreams.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="enabledStream")
        private String enabledStream;
        @JsonProperty(value="installedProfiles")
        private List<String> installedProfiles;
        @JsonProperty(value="activeStreams")
        private List<String> activeStreams;
        @JsonProperty(value="disabledStreams")
        private List<String> disabledStreams;
        @JsonProperty(value="softwareSourceId")
        private String softwareSourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder enabledStream(String enabledStream) {
            this.enabledStream = enabledStream;
            this.__explicitlySet__.add("enabledStream");
            return this;
        }

        public Builder installedProfiles(List<String> installedProfiles) {
            this.installedProfiles = installedProfiles;
            this.__explicitlySet__.add("installedProfiles");
            return this;
        }

        public Builder activeStreams(List<String> activeStreams) {
            this.activeStreams = activeStreams;
            this.__explicitlySet__.add("activeStreams");
            return this;
        }

        public Builder disabledStreams(List<String> disabledStreams) {
            this.disabledStreams = disabledStreams;
            this.__explicitlySet__.add("disabledStreams");
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            this.__explicitlySet__.add("softwareSourceId");
            return this;
        }

        public ManagedInstanceModuleSummary build() {
            ManagedInstanceModuleSummary model = new ManagedInstanceModuleSummary(this.name, this.enabledStream, this.installedProfiles, this.activeStreams, this.disabledStreams, this.softwareSourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceModuleSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("enabledStream")) {
                this.enabledStream(model.getEnabledStream());
            }
            if (model.wasPropertyExplicitlySet("installedProfiles")) {
                this.installedProfiles(model.getInstalledProfiles());
            }
            if (model.wasPropertyExplicitlySet("activeStreams")) {
                this.activeStreams(model.getActiveStreams());
            }
            if (model.wasPropertyExplicitlySet("disabledStreams")) {
                this.disabledStreams(model.getDisabledStreams());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceId")) {
                this.softwareSourceId(model.getSoftwareSourceId());
            }
            return this;
        }
    }
}

