/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.AutonomousSettings;
import com.oracle.bmc.osmanagementhub.model.Id;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceStatus;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="tenancyId")
    private final String tenancyId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="location")
    private final ManagedInstanceLocation location;
    @JsonProperty(value="architecture")
    private final ArchType architecture;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="status")
    private final ManagedInstanceStatus status;
    @JsonProperty(value="managedInstanceGroup")
    private final Id managedInstanceGroup;
    @JsonProperty(value="lifecycleEnvironment")
    private final Id lifecycleEnvironment;
    @JsonProperty(value="lifecycleStage")
    private final Id lifecycleStage;
    @JsonProperty(value="isRebootRequired")
    private final Boolean isRebootRequired;
    @JsonProperty(value="updatesAvailable")
    private final Integer updatesAvailable;
    @JsonProperty(value="isManagementStation")
    private final Boolean isManagementStation;
    @JsonProperty(value="notificationTopicId")
    private final String notificationTopicId;
    @JsonProperty(value="autonomousSettings")
    private final AutonomousSettings autonomousSettings;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "tenancyId", "compartmentId", "location", "architecture", "osFamily", "status", "managedInstanceGroup", "lifecycleEnvironment", "lifecycleStage", "isRebootRequired", "updatesAvailable", "isManagementStation", "notificationTopicId", "autonomousSettings", "isManagedByAutonomousLinux"})
    public ManagedInstanceSummary(String id, String displayName, String description, String tenancyId, String compartmentId, ManagedInstanceLocation location, ArchType architecture, OsFamily osFamily, ManagedInstanceStatus status, Id managedInstanceGroup, Id lifecycleEnvironment, Id lifecycleStage, Boolean isRebootRequired, Integer updatesAvailable, Boolean isManagementStation, String notificationTopicId, AutonomousSettings autonomousSettings, Boolean isManagedByAutonomousLinux) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.tenancyId = tenancyId;
        this.compartmentId = compartmentId;
        this.location = location;
        this.architecture = architecture;
        this.osFamily = osFamily;
        this.status = status;
        this.managedInstanceGroup = managedInstanceGroup;
        this.lifecycleEnvironment = lifecycleEnvironment;
        this.lifecycleStage = lifecycleStage;
        this.isRebootRequired = isRebootRequired;
        this.updatesAvailable = updatesAvailable;
        this.isManagementStation = isManagementStation;
        this.notificationTopicId = notificationTopicId;
        this.autonomousSettings = autonomousSettings;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ManagedInstanceLocation getLocation() {
        return this.location;
    }

    public ArchType getArchitecture() {
        return this.architecture;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ManagedInstanceStatus getStatus() {
        return this.status;
    }

    public Id getManagedInstanceGroup() {
        return this.managedInstanceGroup;
    }

    public Id getLifecycleEnvironment() {
        return this.lifecycleEnvironment;
    }

    public Id getLifecycleStage() {
        return this.lifecycleStage;
    }

    public Boolean getIsRebootRequired() {
        return this.isRebootRequired;
    }

    public Integer getUpdatesAvailable() {
        return this.updatesAvailable;
    }

    public Boolean getIsManagementStation() {
        return this.isManagementStation;
    }

    public String getNotificationTopicId() {
        return this.notificationTopicId;
    }

    public AutonomousSettings getAutonomousSettings() {
        return this.autonomousSettings;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", tenancyId=").append(String.valueOf(this.tenancyId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", location=").append(String.valueOf((Object)this.location));
        sb.append(", architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", managedInstanceGroup=").append(String.valueOf((Object)this.managedInstanceGroup));
        sb.append(", lifecycleEnvironment=").append(String.valueOf((Object)this.lifecycleEnvironment));
        sb.append(", lifecycleStage=").append(String.valueOf((Object)this.lifecycleStage));
        sb.append(", isRebootRequired=").append(String.valueOf(this.isRebootRequired));
        sb.append(", updatesAvailable=").append(String.valueOf(this.updatesAvailable));
        sb.append(", isManagementStation=").append(String.valueOf(this.isManagementStation));
        sb.append(", notificationTopicId=").append(String.valueOf(this.notificationTopicId));
        sb.append(", autonomousSettings=").append(String.valueOf((Object)this.autonomousSettings));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceSummary)) {
            return false;
        }
        ManagedInstanceSummary other = (ManagedInstanceSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.tenancyId, other.tenancyId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.location, (Object)other.location) && Objects.equals((Object)this.architecture, (Object)other.architecture) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.managedInstanceGroup, (Object)other.managedInstanceGroup) && Objects.equals((Object)this.lifecycleEnvironment, (Object)other.lifecycleEnvironment) && Objects.equals((Object)this.lifecycleStage, (Object)other.lifecycleStage) && Objects.equals(this.isRebootRequired, other.isRebootRequired) && Objects.equals(this.updatesAvailable, other.updatesAvailable) && Objects.equals(this.isManagementStation, other.isManagementStation) && Objects.equals(this.notificationTopicId, other.notificationTopicId) && Objects.equals((Object)this.autonomousSettings, (Object)other.autonomousSettings) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.tenancyId == null ? 43 : this.tenancyId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.managedInstanceGroup == null ? 43 : this.managedInstanceGroup.hashCode());
        result = result * 59 + (this.lifecycleEnvironment == null ? 43 : this.lifecycleEnvironment.hashCode());
        result = result * 59 + (this.lifecycleStage == null ? 43 : this.lifecycleStage.hashCode());
        result = result * 59 + (this.isRebootRequired == null ? 43 : this.isRebootRequired.hashCode());
        result = result * 59 + (this.updatesAvailable == null ? 43 : this.updatesAvailable.hashCode());
        result = result * 59 + (this.isManagementStation == null ? 43 : this.isManagementStation.hashCode());
        result = result * 59 + (this.notificationTopicId == null ? 43 : this.notificationTopicId.hashCode());
        result = result * 59 + (this.autonomousSettings == null ? 43 : this.autonomousSettings.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="tenancyId")
        private String tenancyId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="location")
        private ManagedInstanceLocation location;
        @JsonProperty(value="architecture")
        private ArchType architecture;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="status")
        private ManagedInstanceStatus status;
        @JsonProperty(value="managedInstanceGroup")
        private Id managedInstanceGroup;
        @JsonProperty(value="lifecycleEnvironment")
        private Id lifecycleEnvironment;
        @JsonProperty(value="lifecycleStage")
        private Id lifecycleStage;
        @JsonProperty(value="isRebootRequired")
        private Boolean isRebootRequired;
        @JsonProperty(value="updatesAvailable")
        private Integer updatesAvailable;
        @JsonProperty(value="isManagementStation")
        private Boolean isManagementStation;
        @JsonProperty(value="notificationTopicId")
        private String notificationTopicId;
        @JsonProperty(value="autonomousSettings")
        private AutonomousSettings autonomousSettings;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this.tenancyId = tenancyId;
            this.__explicitlySet__.add("tenancyId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder location(ManagedInstanceLocation location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder architecture(ArchType architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder status(ManagedInstanceStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder managedInstanceGroup(Id managedInstanceGroup) {
            this.managedInstanceGroup = managedInstanceGroup;
            this.__explicitlySet__.add("managedInstanceGroup");
            return this;
        }

        public Builder lifecycleEnvironment(Id lifecycleEnvironment) {
            this.lifecycleEnvironment = lifecycleEnvironment;
            this.__explicitlySet__.add("lifecycleEnvironment");
            return this;
        }

        public Builder lifecycleStage(Id lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            this.__explicitlySet__.add("lifecycleStage");
            return this;
        }

        public Builder isRebootRequired(Boolean isRebootRequired) {
            this.isRebootRequired = isRebootRequired;
            this.__explicitlySet__.add("isRebootRequired");
            return this;
        }

        public Builder updatesAvailable(Integer updatesAvailable) {
            this.updatesAvailable = updatesAvailable;
            this.__explicitlySet__.add("updatesAvailable");
            return this;
        }

        public Builder isManagementStation(Boolean isManagementStation) {
            this.isManagementStation = isManagementStation;
            this.__explicitlySet__.add("isManagementStation");
            return this;
        }

        public Builder notificationTopicId(String notificationTopicId) {
            this.notificationTopicId = notificationTopicId;
            this.__explicitlySet__.add("notificationTopicId");
            return this;
        }

        public Builder autonomousSettings(AutonomousSettings autonomousSettings) {
            this.autonomousSettings = autonomousSettings;
            this.__explicitlySet__.add("autonomousSettings");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public ManagedInstanceSummary build() {
            ManagedInstanceSummary model = new ManagedInstanceSummary(this.id, this.displayName, this.description, this.tenancyId, this.compartmentId, this.location, this.architecture, this.osFamily, this.status, this.managedInstanceGroup, this.lifecycleEnvironment, this.lifecycleStage, this.isRebootRequired, this.updatesAvailable, this.isManagementStation, this.notificationTopicId, this.autonomousSettings, this.isManagedByAutonomousLinux);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("tenancyId")) {
                this.tenancyId(model.getTenancyId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceGroup")) {
                this.managedInstanceGroup(model.getManagedInstanceGroup());
            }
            if (model.wasPropertyExplicitlySet("lifecycleEnvironment")) {
                this.lifecycleEnvironment(model.getLifecycleEnvironment());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStage")) {
                this.lifecycleStage(model.getLifecycleStage());
            }
            if (model.wasPropertyExplicitlySet("isRebootRequired")) {
                this.isRebootRequired(model.getIsRebootRequired());
            }
            if (model.wasPropertyExplicitlySet("updatesAvailable")) {
                this.updatesAvailable(model.getUpdatesAvailable());
            }
            if (model.wasPropertyExplicitlySet("isManagementStation")) {
                this.isManagementStation(model.getIsManagementStation());
            }
            if (model.wasPropertyExplicitlySet("notificationTopicId")) {
                this.notificationTopicId(model.getNotificationTopicId());
            }
            if (model.wasPropertyExplicitlySet("autonomousSettings")) {
                this.autonomousSettings(model.getAutonomousSettings());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            return this;
        }
    }
}

