/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.MirrorConfiguration;
import com.oracle.bmc.osmanagementhub.model.MirrorSyncStatus;
import com.oracle.bmc.osmanagementhub.model.OverallState;
import com.oracle.bmc.osmanagementhub.model.ProxyConfiguration;
import com.oracle.bmc.osmanagementhub.model.StationHealth;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagementStation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="scheduledJobId")
    private final String scheduledJobId;
    @JsonProperty(value="profileId")
    private final String profileId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="overallState")
    private final OverallState overallState;
    @JsonProperty(value="overallPercentage")
    private final Integer overallPercentage;
    @JsonProperty(value="mirrorCapacity")
    private final Integer mirrorCapacity;
    @JsonProperty(value="totalMirrors")
    private final Integer totalMirrors;
    @JsonProperty(value="mirrorSyncStatus")
    private final MirrorSyncStatus mirrorSyncStatus;
    @JsonProperty(value="proxy")
    private final ProxyConfiguration proxy;
    @JsonProperty(value="mirror")
    private final MirrorConfiguration mirror;
    @JsonProperty(value="health")
    private final StationHealth health;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "managedInstanceId", "compartmentId", "scheduledJobId", "profileId", "displayName", "description", "hostname", "overallState", "overallPercentage", "mirrorCapacity", "totalMirrors", "mirrorSyncStatus", "proxy", "mirror", "health", "lifecycleState", "freeformTags", "definedTags", "systemTags"})
    public ManagementStation(String id, String managedInstanceId, String compartmentId, String scheduledJobId, String profileId, String displayName, String description, String hostname, OverallState overallState, Integer overallPercentage, Integer mirrorCapacity, Integer totalMirrors, MirrorSyncStatus mirrorSyncStatus, ProxyConfiguration proxy, MirrorConfiguration mirror, StationHealth health, LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.managedInstanceId = managedInstanceId;
        this.compartmentId = compartmentId;
        this.scheduledJobId = scheduledJobId;
        this.profileId = profileId;
        this.displayName = displayName;
        this.description = description;
        this.hostname = hostname;
        this.overallState = overallState;
        this.overallPercentage = overallPercentage;
        this.mirrorCapacity = mirrorCapacity;
        this.totalMirrors = totalMirrors;
        this.mirrorSyncStatus = mirrorSyncStatus;
        this.proxy = proxy;
        this.mirror = mirror;
        this.health = health;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getScheduledJobId() {
        return this.scheduledJobId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHostname() {
        return this.hostname;
    }

    public OverallState getOverallState() {
        return this.overallState;
    }

    public Integer getOverallPercentage() {
        return this.overallPercentage;
    }

    public Integer getMirrorCapacity() {
        return this.mirrorCapacity;
    }

    public Integer getTotalMirrors() {
        return this.totalMirrors;
    }

    public MirrorSyncStatus getMirrorSyncStatus() {
        return this.mirrorSyncStatus;
    }

    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public MirrorConfiguration getMirror() {
        return this.mirror;
    }

    public StationHealth getHealth() {
        return this.health;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagementStation(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", scheduledJobId=").append(String.valueOf(this.scheduledJobId));
        sb.append(", profileId=").append(String.valueOf(this.profileId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", overallState=").append(String.valueOf((Object)this.overallState));
        sb.append(", overallPercentage=").append(String.valueOf(this.overallPercentage));
        sb.append(", mirrorCapacity=").append(String.valueOf(this.mirrorCapacity));
        sb.append(", totalMirrors=").append(String.valueOf(this.totalMirrors));
        sb.append(", mirrorSyncStatus=").append(String.valueOf((Object)this.mirrorSyncStatus));
        sb.append(", proxy=").append(String.valueOf((Object)this.proxy));
        sb.append(", mirror=").append(String.valueOf((Object)this.mirror));
        sb.append(", health=").append(String.valueOf((Object)this.health));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagementStation)) {
            return false;
        }
        ManagementStation other = (ManagementStation)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.scheduledJobId, other.scheduledJobId) && Objects.equals(this.profileId, other.profileId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.hostname, other.hostname) && Objects.equals((Object)this.overallState, (Object)other.overallState) && Objects.equals(this.overallPercentage, other.overallPercentage) && Objects.equals(this.mirrorCapacity, other.mirrorCapacity) && Objects.equals(this.totalMirrors, other.totalMirrors) && Objects.equals((Object)this.mirrorSyncStatus, (Object)other.mirrorSyncStatus) && Objects.equals((Object)this.proxy, (Object)other.proxy) && Objects.equals((Object)this.mirror, (Object)other.mirror) && Objects.equals((Object)this.health, (Object)other.health) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.scheduledJobId == null ? 43 : this.scheduledJobId.hashCode());
        result = result * 59 + (this.profileId == null ? 43 : this.profileId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.overallState == null ? 43 : this.overallState.hashCode());
        result = result * 59 + (this.overallPercentage == null ? 43 : this.overallPercentage.hashCode());
        result = result * 59 + (this.mirrorCapacity == null ? 43 : this.mirrorCapacity.hashCode());
        result = result * 59 + (this.totalMirrors == null ? 43 : this.totalMirrors.hashCode());
        result = result * 59 + (this.mirrorSyncStatus == null ? 43 : this.mirrorSyncStatus.hashCode());
        result = result * 59 + (this.proxy == null ? 43 : this.proxy.hashCode());
        result = result * 59 + (this.mirror == null ? 43 : this.mirror.hashCode());
        result = result * 59 + (this.health == null ? 43 : this.health.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="scheduledJobId")
        private String scheduledJobId;
        @JsonProperty(value="profileId")
        private String profileId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="overallState")
        private OverallState overallState;
        @JsonProperty(value="overallPercentage")
        private Integer overallPercentage;
        @JsonProperty(value="mirrorCapacity")
        private Integer mirrorCapacity;
        @JsonProperty(value="totalMirrors")
        private Integer totalMirrors;
        @JsonProperty(value="mirrorSyncStatus")
        private MirrorSyncStatus mirrorSyncStatus;
        @JsonProperty(value="proxy")
        private ProxyConfiguration proxy;
        @JsonProperty(value="mirror")
        private MirrorConfiguration mirror;
        @JsonProperty(value="health")
        private StationHealth health;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder scheduledJobId(String scheduledJobId) {
            this.scheduledJobId = scheduledJobId;
            this.__explicitlySet__.add("scheduledJobId");
            return this;
        }

        public Builder profileId(String profileId) {
            this.profileId = profileId;
            this.__explicitlySet__.add("profileId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder overallState(OverallState overallState) {
            this.overallState = overallState;
            this.__explicitlySet__.add("overallState");
            return this;
        }

        public Builder overallPercentage(Integer overallPercentage) {
            this.overallPercentage = overallPercentage;
            this.__explicitlySet__.add("overallPercentage");
            return this;
        }

        public Builder mirrorCapacity(Integer mirrorCapacity) {
            this.mirrorCapacity = mirrorCapacity;
            this.__explicitlySet__.add("mirrorCapacity");
            return this;
        }

        public Builder totalMirrors(Integer totalMirrors) {
            this.totalMirrors = totalMirrors;
            this.__explicitlySet__.add("totalMirrors");
            return this;
        }

        public Builder mirrorSyncStatus(MirrorSyncStatus mirrorSyncStatus) {
            this.mirrorSyncStatus = mirrorSyncStatus;
            this.__explicitlySet__.add("mirrorSyncStatus");
            return this;
        }

        public Builder proxy(ProxyConfiguration proxy) {
            this.proxy = proxy;
            this.__explicitlySet__.add("proxy");
            return this;
        }

        public Builder mirror(MirrorConfiguration mirror) {
            this.mirror = mirror;
            this.__explicitlySet__.add("mirror");
            return this;
        }

        public Builder health(StationHealth health) {
            this.health = health;
            this.__explicitlySet__.add("health");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public ManagementStation build() {
            ManagementStation model = new ManagementStation(this.id, this.managedInstanceId, this.compartmentId, this.scheduledJobId, this.profileId, this.displayName, this.description, this.hostname, this.overallState, this.overallPercentage, this.mirrorCapacity, this.totalMirrors, this.mirrorSyncStatus, this.proxy, this.mirror, this.health, this.lifecycleState, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagementStation model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("scheduledJobId")) {
                this.scheduledJobId(model.getScheduledJobId());
            }
            if (model.wasPropertyExplicitlySet("profileId")) {
                this.profileId(model.getProfileId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("overallState")) {
                this.overallState(model.getOverallState());
            }
            if (model.wasPropertyExplicitlySet("overallPercentage")) {
                this.overallPercentage(model.getOverallPercentage());
            }
            if (model.wasPropertyExplicitlySet("mirrorCapacity")) {
                this.mirrorCapacity(model.getMirrorCapacity());
            }
            if (model.wasPropertyExplicitlySet("totalMirrors")) {
                this.totalMirrors(model.getTotalMirrors());
            }
            if (model.wasPropertyExplicitlySet("mirrorSyncStatus")) {
                this.mirrorSyncStatus(model.getMirrorSyncStatus());
            }
            if (model.wasPropertyExplicitlySet("proxy")) {
                this.proxy(model.getProxy());
            }
            if (model.wasPropertyExplicitlySet("mirror")) {
                this.mirror(model.getMirror());
            }
            if (model.wasPropertyExplicitlySet("health")) {
                this.health(model.getHealth());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

