/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetricName implements BmcEnum
{
    TotalInstanceCount("TOTAL_INSTANCE_COUNT"),
    InstanceWithAvailableSecurityUpdatesCount("INSTANCE_WITH_AVAILABLE_SECURITY_UPDATES_COUNT"),
    InstanceWithAvailableBugfixUpdatesCount("INSTANCE_WITH_AVAILABLE_BUGFIX_UPDATES_COUNT"),
    NormalInstanceCount("NORMAL_INSTANCE_COUNT"),
    ErrorInstanceCount("ERROR_INSTANCE_COUNT"),
    WarningInstanceCount("WARNING_INSTANCE_COUNT"),
    UnreachableInstanceCount("UNREACHABLE_INSTANCE_COUNT"),
    RegistrationFailedInstanceCount("REGISTRATION_FAILED_INSTANCE_COUNT"),
    DeletingInstanceCount("DELETING_INSTANCE_COUNT"),
    OnboardingInstanceCount("ONBOARDING_INSTANCE_COUNT"),
    InstanceSecurityUpdatesCount("INSTANCE_SECURITY_UPDATES_COUNT"),
    InstanceBugfixUpdatesCount("INSTANCE_BUGFIX_UPDATES_COUNT"),
    InstanceSecurityAdvisoryCount("INSTANCE_SECURITY_ADVISORY_COUNT"),
    InstanceBugfixAdvisoryCount("INSTANCE_BUGFIX_ADVISORY_COUNT"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, MetricName> map;

    private MetricName(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static MetricName create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'MetricName', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(MetricName.class);
        map = new HashMap<String, MetricName>();
        for (MetricName v : MetricName.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

