/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.MirrorState;
import com.oracle.bmc.osmanagementhub.model.MirrorType;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MirrorSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final MirrorType type;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="archType")
    private final ArchType archType;
    @JsonProperty(value="state")
    private final MirrorState state;
    @JsonProperty(value="percentage")
    private final Integer percentage;
    @JsonProperty(value="timeLastSynced")
    private final Date timeLastSynced;
    @JsonProperty(value="log")
    private final String log;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "type", "osFamily", "archType", "state", "percentage", "timeLastSynced", "log"})
    public MirrorSummary(String id, String displayName, MirrorType type, OsFamily osFamily, ArchType archType, MirrorState state, Integer percentage, Date timeLastSynced, String log) {
        this.id = id;
        this.displayName = displayName;
        this.type = type;
        this.osFamily = osFamily;
        this.archType = archType;
        this.state = state;
        this.percentage = percentage;
        this.timeLastSynced = timeLastSynced;
        this.log = log;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MirrorType getType() {
        return this.type;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ArchType getArchType() {
        return this.archType;
    }

    public MirrorState getState() {
        return this.state;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public Date getTimeLastSynced() {
        return this.timeLastSynced;
    }

    public String getLog() {
        return this.log;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MirrorSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", archType=").append(String.valueOf((Object)this.archType));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", percentage=").append(String.valueOf(this.percentage));
        sb.append(", timeLastSynced=").append(String.valueOf(this.timeLastSynced));
        sb.append(", log=").append(String.valueOf(this.log));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MirrorSummary)) {
            return false;
        }
        MirrorSummary other = (MirrorSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.timeLastSynced, other.timeLastSynced) && Objects.equals(this.log, other.log) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.percentage == null ? 43 : this.percentage.hashCode());
        result = result * 59 + (this.timeLastSynced == null ? 43 : this.timeLastSynced.hashCode());
        result = result * 59 + (this.log == null ? 43 : this.log.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private MirrorType type;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="archType")
        private ArchType archType;
        @JsonProperty(value="state")
        private MirrorState state;
        @JsonProperty(value="percentage")
        private Integer percentage;
        @JsonProperty(value="timeLastSynced")
        private Date timeLastSynced;
        @JsonProperty(value="log")
        private String log;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(MirrorType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder archType(ArchType archType) {
            this.archType = archType;
            this.__explicitlySet__.add("archType");
            return this;
        }

        public Builder state(MirrorState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder percentage(Integer percentage) {
            this.percentage = percentage;
            this.__explicitlySet__.add("percentage");
            return this;
        }

        public Builder timeLastSynced(Date timeLastSynced) {
            this.timeLastSynced = timeLastSynced;
            this.__explicitlySet__.add("timeLastSynced");
            return this;
        }

        public Builder log(String log) {
            this.log = log;
            this.__explicitlySet__.add("log");
            return this;
        }

        public MirrorSummary build() {
            MirrorSummary model = new MirrorSummary(this.id, this.displayName, this.type, this.osFamily, this.archType, this.state, this.percentage, this.timeLastSynced, this.log);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MirrorSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("archType")) {
                this.archType(model.getArchType());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("percentage")) {
                this.percentage(model.getPercentage());
            }
            if (model.wasPropertyExplicitlySet("timeLastSynced")) {
                this.timeLastSynced(model.getTimeLastSynced());
            }
            if (model.wasPropertyExplicitlySet("log")) {
                this.log(model.getLog());
            }
            return this;
        }
    }
}

