/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStreamDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="softwareSourceId")
    private final String softwareSourceId;

    @Deprecated
    @ConstructorProperties(value={"moduleName", "streamName", "softwareSourceId"})
    public ModuleStreamDetails(String moduleName, String streamName, String softwareSourceId) {
        this.moduleName = moduleName;
        this.streamName = streamName;
        this.softwareSourceId = softwareSourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStreamDetails(");
        sb.append("super=").append(super.toString());
        sb.append("moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", streamName=").append(String.valueOf(this.streamName));
        sb.append(", softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStreamDetails)) {
            return false;
        }
        ModuleStreamDetails other = (ModuleStreamDetails)((Object)o);
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.streamName, other.streamName) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="softwareSourceId")
        private String softwareSourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            this.__explicitlySet__.add("softwareSourceId");
            return this;
        }

        public ModuleStreamDetails build() {
            ModuleStreamDetails model = new ModuleStreamDetails(this.moduleName, this.streamName, this.softwareSourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStreamDetails model) {
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceId")) {
                this.softwareSourceId(model.getSoftwareSourceId());
            }
            return this;
        }
    }
}

