/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.FilterType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStreamProfileFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="profileName")
    private final String profileName;
    @JsonProperty(value="streamName")
    private final String streamName;
    @JsonProperty(value="filterType")
    private final FilterType filterType;

    @Deprecated
    @ConstructorProperties(value={"moduleName", "profileName", "streamName", "filterType"})
    public ModuleStreamProfileFilter(String moduleName, String profileName, String streamName, FilterType filterType) {
        this.moduleName = moduleName;
        this.profileName = profileName;
        this.streamName = streamName;
        this.filterType = filterType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStreamProfileFilter(");
        sb.append("super=").append(super.toString());
        sb.append("moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", profileName=").append(String.valueOf(this.profileName));
        sb.append(", streamName=").append(String.valueOf(this.streamName));
        sb.append(", filterType=").append(String.valueOf((Object)this.filterType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStreamProfileFilter)) {
            return false;
        }
        ModuleStreamProfileFilter other = (ModuleStreamProfileFilter)((Object)o);
        return Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.profileName, other.profileName) && Objects.equals(this.streamName, other.streamName) && Objects.equals((Object)this.filterType, (Object)other.filterType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.profileName == null ? 43 : this.profileName.hashCode());
        result = result * 59 + (this.streamName == null ? 43 : this.streamName.hashCode());
        result = result * 59 + (this.filterType == null ? 43 : this.filterType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="profileName")
        private String profileName;
        @JsonProperty(value="streamName")
        private String streamName;
        @JsonProperty(value="filterType")
        private FilterType filterType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            this.__explicitlySet__.add("profileName");
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            this.__explicitlySet__.add("streamName");
            return this;
        }

        public Builder filterType(FilterType filterType) {
            this.filterType = filterType;
            this.__explicitlySet__.add("filterType");
            return this;
        }

        public ModuleStreamProfileFilter build() {
            ModuleStreamProfileFilter model = new ModuleStreamProfileFilter(this.moduleName, this.profileName, this.streamName, this.filterType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStreamProfileFilter model) {
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("profileName")) {
                this.profileName(model.getProfileName());
            }
            if (model.wasPropertyExplicitlySet("streamName")) {
                this.streamName(model.getStreamName());
            }
            if (model.wasPropertyExplicitlySet("filterType")) {
                this.filterType(model.getFilterType());
            }
            return this;
        }
    }
}

