/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModuleStreamSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="moduleName")
    private final String moduleName;
    @JsonProperty(value="profiles")
    private final List<String> profiles;
    @JsonProperty(value="isLatest")
    private final Boolean isLatest;
    @JsonProperty(value="softwareSourceId")
    private final String softwareSourceId;

    @Deprecated
    @ConstructorProperties(value={"name", "moduleName", "profiles", "isLatest", "softwareSourceId"})
    public ModuleStreamSummary(String name, String moduleName, List<String> profiles, Boolean isLatest, String softwareSourceId) {
        this.name = name;
        this.moduleName = moduleName;
        this.profiles = profiles;
        this.isLatest = isLatest;
        this.softwareSourceId = softwareSourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public Boolean getIsLatest() {
        return this.isLatest;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleStreamSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", moduleName=").append(String.valueOf(this.moduleName));
        sb.append(", profiles=").append(String.valueOf(this.profiles));
        sb.append(", isLatest=").append(String.valueOf(this.isLatest));
        sb.append(", softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleStreamSummary)) {
            return false;
        }
        ModuleStreamSummary other = (ModuleStreamSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.profiles, other.profiles) && Objects.equals(this.isLatest, other.isLatest) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.moduleName == null ? 43 : this.moduleName.hashCode());
        result = result * 59 + (this.profiles == null ? 43 : this.profiles.hashCode());
        result = result * 59 + (this.isLatest == null ? 43 : this.isLatest.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="moduleName")
        private String moduleName;
        @JsonProperty(value="profiles")
        private List<String> profiles;
        @JsonProperty(value="isLatest")
        private Boolean isLatest;
        @JsonProperty(value="softwareSourceId")
        private String softwareSourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            this.__explicitlySet__.add("moduleName");
            return this;
        }

        public Builder profiles(List<String> profiles) {
            this.profiles = profiles;
            this.__explicitlySet__.add("profiles");
            return this;
        }

        public Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            this.__explicitlySet__.add("isLatest");
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            this.__explicitlySet__.add("softwareSourceId");
            return this;
        }

        public ModuleStreamSummary build() {
            ModuleStreamSummary model = new ModuleStreamSummary(this.name, this.moduleName, this.profiles, this.isLatest, this.softwareSourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModuleStreamSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("moduleName")) {
                this.moduleName(model.getModuleName());
            }
            if (model.wasPropertyExplicitlySet("profiles")) {
                this.profiles(model.getProfiles());
            }
            if (model.wasPropertyExplicitlySet("isLatest")) {
                this.isLatest(model.getIsLatest());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceId")) {
                this.softwareSourceId(model.getSoftwareSourceId());
            }
            return this;
        }
    }
}

