/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.FilterType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PackageFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="packageName")
    private final String packageName;
    @JsonProperty(value="packageNamePattern")
    private final String packageNamePattern;
    @JsonProperty(value="packageVersion")
    private final String packageVersion;
    @JsonProperty(value="filterType")
    private final FilterType filterType;

    @Deprecated
    @ConstructorProperties(value={"packageName", "packageNamePattern", "packageVersion", "filterType"})
    public PackageFilter(String packageName, String packageNamePattern, String packageVersion, FilterType filterType) {
        this.packageName = packageName;
        this.packageNamePattern = packageNamePattern;
        this.packageVersion = packageVersion;
        this.filterType = filterType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageNamePattern() {
        return this.packageNamePattern;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageFilter(");
        sb.append("super=").append(super.toString());
        sb.append("packageName=").append(String.valueOf(this.packageName));
        sb.append(", packageNamePattern=").append(String.valueOf(this.packageNamePattern));
        sb.append(", packageVersion=").append(String.valueOf(this.packageVersion));
        sb.append(", filterType=").append(String.valueOf((Object)this.filterType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFilter)) {
            return false;
        }
        PackageFilter other = (PackageFilter)((Object)o);
        return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.packageNamePattern, other.packageNamePattern) && Objects.equals(this.packageVersion, other.packageVersion) && Objects.equals((Object)this.filterType, (Object)other.filterType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.packageName == null ? 43 : this.packageName.hashCode());
        result = result * 59 + (this.packageNamePattern == null ? 43 : this.packageNamePattern.hashCode());
        result = result * 59 + (this.packageVersion == null ? 43 : this.packageVersion.hashCode());
        result = result * 59 + (this.filterType == null ? 43 : this.filterType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="packageName")
        private String packageName;
        @JsonProperty(value="packageNamePattern")
        private String packageNamePattern;
        @JsonProperty(value="packageVersion")
        private String packageVersion;
        @JsonProperty(value="filterType")
        private FilterType filterType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            this.__explicitlySet__.add("packageName");
            return this;
        }

        public Builder packageNamePattern(String packageNamePattern) {
            this.packageNamePattern = packageNamePattern;
            this.__explicitlySet__.add("packageNamePattern");
            return this;
        }

        public Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            this.__explicitlySet__.add("packageVersion");
            return this;
        }

        public Builder filterType(FilterType filterType) {
            this.filterType = filterType;
            this.__explicitlySet__.add("filterType");
            return this;
        }

        public PackageFilter build() {
            PackageFilter model = new PackageFilter(this.packageName, this.packageNamePattern, this.packageVersion, this.filterType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PackageFilter model) {
            if (model.wasPropertyExplicitlySet("packageName")) {
                this.packageName(model.getPackageName());
            }
            if (model.wasPropertyExplicitlySet("packageNamePattern")) {
                this.packageNamePattern(model.getPackageNamePattern());
            }
            if (model.wasPropertyExplicitlySet("packageVersion")) {
                this.packageVersion(model.getPackageVersion());
            }
            if (model.wasPropertyExplicitlySet("filterType")) {
                this.filterType(model.getFilterType());
            }
            return this;
        }
    }
}

