/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PackageGroup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="repositories")
    private final List<String> repositories;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isUserVisible")
    private final Boolean isUserVisible;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="groupType")
    private final GroupType groupType;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;
    @JsonProperty(value="packages")
    private final List<String> packages;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "repositories", "description", "isUserVisible", "isDefault", "groupType", "displayOrder", "packages"})
    public PackageGroup(String id, String name, List<String> repositories, String description, Boolean isUserVisible, Boolean isDefault, GroupType groupType, Integer displayOrder, List<String> packages) {
        this.id = id;
        this.name = name;
        this.repositories = repositories;
        this.description = description;
        this.isUserVisible = isUserVisible;
        this.isDefault = isDefault;
        this.groupType = groupType;
        this.displayOrder = displayOrder;
        this.packages = packages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsUserVisible() {
        return this.isUserVisible;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageGroup(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", repositories=").append(String.valueOf(this.repositories));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isUserVisible=").append(String.valueOf(this.isUserVisible));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", groupType=").append(String.valueOf((Object)this.groupType));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(", packages=").append(String.valueOf(this.packages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageGroup)) {
            return false;
        }
        PackageGroup other = (PackageGroup)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.repositories, other.repositories) && Objects.equals(this.description, other.description) && Objects.equals(this.isUserVisible, other.isUserVisible) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals((Object)this.groupType, (Object)other.groupType) && Objects.equals(this.displayOrder, other.displayOrder) && Objects.equals(this.packages, other.packages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.repositories == null ? 43 : this.repositories.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isUserVisible == null ? 43 : this.isUserVisible.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.groupType == null ? 43 : this.groupType.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + (this.packages == null ? 43 : this.packages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum GroupType implements BmcEnum
    {
        Group("GROUP"),
        Environment("ENVIRONMENT"),
        Category("CATEGORY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GroupType> map;

        private GroupType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GroupType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GroupType.class);
            map = new HashMap<String, GroupType>();
            for (GroupType v : GroupType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="repositories")
        private List<String> repositories;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isUserVisible")
        private Boolean isUserVisible;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="groupType")
        private GroupType groupType;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonProperty(value="packages")
        private List<String> packages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder repositories(List<String> repositories) {
            this.repositories = repositories;
            this.__explicitlySet__.add("repositories");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isUserVisible(Boolean isUserVisible) {
            this.isUserVisible = isUserVisible;
            this.__explicitlySet__.add("isUserVisible");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder groupType(GroupType groupType) {
            this.groupType = groupType;
            this.__explicitlySet__.add("groupType");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public Builder packages(List<String> packages) {
            this.packages = packages;
            this.__explicitlySet__.add("packages");
            return this;
        }

        public PackageGroup build() {
            PackageGroup model = new PackageGroup(this.id, this.name, this.repositories, this.description, this.isUserVisible, this.isDefault, this.groupType, this.displayOrder, this.packages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PackageGroup model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("repositories")) {
                this.repositories(model.getRepositories());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isUserVisible")) {
                this.isUserVisible(model.getIsUserVisible());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("groupType")) {
                this.groupType(model.getGroupType());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            if (model.wasPropertyExplicitlySet("packages")) {
                this.packages(model.getPackages());
            }
            return this;
        }
    }
}

