/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.PackageGroup;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PackageGroupSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isUserVisible")
    private final Boolean isUserVisible;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="repositories")
    private final List<String> repositories;
    @JsonProperty(value="groupType")
    private final PackageGroup.GroupType groupType;
    @JsonProperty(value="displayOrder")
    private final Integer displayOrder;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "description", "isUserVisible", "isDefault", "repositories", "groupType", "displayOrder"})
    public PackageGroupSummary(String id, String name, String description, Boolean isUserVisible, Boolean isDefault, List<String> repositories, PackageGroup.GroupType groupType, Integer displayOrder) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isUserVisible = isUserVisible;
        this.isDefault = isDefault;
        this.repositories = repositories;
        this.groupType = groupType;
        this.displayOrder = displayOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsUserVisible() {
        return this.isUserVisible;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public PackageGroup.GroupType getGroupType() {
        return this.groupType;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageGroupSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isUserVisible=").append(String.valueOf(this.isUserVisible));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", repositories=").append(String.valueOf(this.repositories));
        sb.append(", groupType=").append(String.valueOf((Object)this.groupType));
        sb.append(", displayOrder=").append(String.valueOf(this.displayOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageGroupSummary)) {
            return false;
        }
        PackageGroupSummary other = (PackageGroupSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.isUserVisible, other.isUserVisible) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.repositories, other.repositories) && Objects.equals((Object)this.groupType, (Object)other.groupType) && Objects.equals(this.displayOrder, other.displayOrder) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isUserVisible == null ? 43 : this.isUserVisible.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.repositories == null ? 43 : this.repositories.hashCode());
        result = result * 59 + (this.groupType == null ? 43 : this.groupType.hashCode());
        result = result * 59 + (this.displayOrder == null ? 43 : this.displayOrder.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isUserVisible")
        private Boolean isUserVisible;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="repositories")
        private List<String> repositories;
        @JsonProperty(value="groupType")
        private PackageGroup.GroupType groupType;
        @JsonProperty(value="displayOrder")
        private Integer displayOrder;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isUserVisible(Boolean isUserVisible) {
            this.isUserVisible = isUserVisible;
            this.__explicitlySet__.add("isUserVisible");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder repositories(List<String> repositories) {
            this.repositories = repositories;
            this.__explicitlySet__.add("repositories");
            return this;
        }

        public Builder groupType(PackageGroup.GroupType groupType) {
            this.groupType = groupType;
            this.__explicitlySet__.add("groupType");
            return this;
        }

        public Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            this.__explicitlySet__.add("displayOrder");
            return this;
        }

        public PackageGroupSummary build() {
            PackageGroupSummary model = new PackageGroupSummary(this.id, this.name, this.description, this.isUserVisible, this.isDefault, this.repositories, this.groupType, this.displayOrder);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PackageGroupSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isUserVisible")) {
                this.isUserVisible(model.getIsUserVisible());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("repositories")) {
                this.repositories(model.getRepositories());
            }
            if (model.wasPropertyExplicitlySet("groupType")) {
                this.groupType(model.getGroupType());
            }
            if (model.wasPropertyExplicitlySet("displayOrder")) {
                this.displayOrder(model.getDisplayOrder());
            }
            return this;
        }
    }
}

