/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.AvailablePackageSummary;
import com.oracle.bmc.osmanagementhub.model.InstalledPackageSummary;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceDetails;
import com.oracle.bmc.osmanagementhub.model.UpdatablePackageSummary;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageClassification", defaultImpl=PackageSummary.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AvailablePackageSummary.class, name="AVAILABLE"), @JsonSubTypes.Type(value=InstalledPackageSummary.class, name="INSTALLED"), @JsonSubTypes.Type(value=UpdatablePackageSummary.class, name="UPDATABLE")})
@JsonFilter(value="explicitlySetFilter")
public class PackageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="architecture")
    private final ArchType architecture;
    @JsonProperty(value="softwareSources")
    private final List<SoftwareSourceDetails> softwareSources;

    @Deprecated
    @ConstructorProperties(value={"displayName", "name", "type", "version", "architecture", "softwareSources"})
    protected PackageSummary(String displayName, String name, String type, String version, ArchType architecture, List<SoftwareSourceDetails> softwareSources) {
        this.displayName = displayName;
        this.name = name;
        this.type = type;
        this.version = version;
        this.architecture = architecture;
        this.softwareSources = softwareSources;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public ArchType getArchitecture() {
        return this.architecture;
    }

    public List<SoftwareSourceDetails> getSoftwareSources() {
        return this.softwareSources;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", architecture=").append(String.valueOf((Object)this.architecture));
        sb.append(", softwareSources=").append(String.valueOf(this.softwareSources));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageSummary)) {
            return false;
        }
        PackageSummary other = (PackageSummary)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.architecture, (Object)other.architecture) && Objects.equals(this.softwareSources, other.softwareSources) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.softwareSources == null ? 43 : this.softwareSources.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PackageClassification implements BmcEnum
    {
        Installed("INSTALLED"),
        Available("AVAILABLE"),
        Updatable("UPDATABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PackageClassification> map;

        private PackageClassification(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PackageClassification create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PackageClassification', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PackageClassification.class);
            map = new HashMap<String, PackageClassification>();
            for (PackageClassification v : PackageClassification.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

