/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ManageModuleStreamsInScheduledJobDetails;
import com.oracle.bmc.osmanagementhub.model.ModuleStreamDetails;
import com.oracle.bmc.osmanagementhub.model.OperationTypes;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledJobOperation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final OperationTypes operationType;
    @JsonProperty(value="packageNames")
    private final List<String> packageNames;
    @JsonProperty(value="windowsUpdateNames")
    private final List<String> windowsUpdateNames;
    @JsonProperty(value="manageModuleStreamsDetails")
    private final ManageModuleStreamsInScheduledJobDetails manageModuleStreamsDetails;
    @JsonProperty(value="switchModuleStreamsDetails")
    private final ModuleStreamDetails switchModuleStreamsDetails;
    @JsonProperty(value="softwareSourceIds")
    private final List<String> softwareSourceIds;

    @Deprecated
    @ConstructorProperties(value={"operationType", "packageNames", "windowsUpdateNames", "manageModuleStreamsDetails", "switchModuleStreamsDetails", "softwareSourceIds"})
    public ScheduledJobOperation(OperationTypes operationType, List<String> packageNames, List<String> windowsUpdateNames, ManageModuleStreamsInScheduledJobDetails manageModuleStreamsDetails, ModuleStreamDetails switchModuleStreamsDetails, List<String> softwareSourceIds) {
        this.operationType = operationType;
        this.packageNames = packageNames;
        this.windowsUpdateNames = windowsUpdateNames;
        this.manageModuleStreamsDetails = manageModuleStreamsDetails;
        this.switchModuleStreamsDetails = switchModuleStreamsDetails;
        this.softwareSourceIds = softwareSourceIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationTypes getOperationType() {
        return this.operationType;
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public List<String> getWindowsUpdateNames() {
        return this.windowsUpdateNames;
    }

    public ManageModuleStreamsInScheduledJobDetails getManageModuleStreamsDetails() {
        return this.manageModuleStreamsDetails;
    }

    public ModuleStreamDetails getSwitchModuleStreamsDetails() {
        return this.switchModuleStreamsDetails;
    }

    public List<String> getSoftwareSourceIds() {
        return this.softwareSourceIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledJobOperation(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", packageNames=").append(String.valueOf(this.packageNames));
        sb.append(", windowsUpdateNames=").append(String.valueOf(this.windowsUpdateNames));
        sb.append(", manageModuleStreamsDetails=").append(String.valueOf((Object)this.manageModuleStreamsDetails));
        sb.append(", switchModuleStreamsDetails=").append(String.valueOf((Object)this.switchModuleStreamsDetails));
        sb.append(", softwareSourceIds=").append(String.valueOf(this.softwareSourceIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledJobOperation)) {
            return false;
        }
        ScheduledJobOperation other = (ScheduledJobOperation)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.packageNames, other.packageNames) && Objects.equals(this.windowsUpdateNames, other.windowsUpdateNames) && Objects.equals((Object)this.manageModuleStreamsDetails, (Object)other.manageModuleStreamsDetails) && Objects.equals((Object)this.switchModuleStreamsDetails, (Object)other.switchModuleStreamsDetails) && Objects.equals(this.softwareSourceIds, other.softwareSourceIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.packageNames == null ? 43 : this.packageNames.hashCode());
        result = result * 59 + (this.windowsUpdateNames == null ? 43 : this.windowsUpdateNames.hashCode());
        result = result * 59 + (this.manageModuleStreamsDetails == null ? 43 : this.manageModuleStreamsDetails.hashCode());
        result = result * 59 + (this.switchModuleStreamsDetails == null ? 43 : this.switchModuleStreamsDetails.hashCode());
        result = result * 59 + (this.softwareSourceIds == null ? 43 : this.softwareSourceIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationTypes operationType;
        @JsonProperty(value="packageNames")
        private List<String> packageNames;
        @JsonProperty(value="windowsUpdateNames")
        private List<String> windowsUpdateNames;
        @JsonProperty(value="manageModuleStreamsDetails")
        private ManageModuleStreamsInScheduledJobDetails manageModuleStreamsDetails;
        @JsonProperty(value="switchModuleStreamsDetails")
        private ModuleStreamDetails switchModuleStreamsDetails;
        @JsonProperty(value="softwareSourceIds")
        private List<String> softwareSourceIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationTypes operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder packageNames(List<String> packageNames) {
            this.packageNames = packageNames;
            this.__explicitlySet__.add("packageNames");
            return this;
        }

        public Builder windowsUpdateNames(List<String> windowsUpdateNames) {
            this.windowsUpdateNames = windowsUpdateNames;
            this.__explicitlySet__.add("windowsUpdateNames");
            return this;
        }

        public Builder manageModuleStreamsDetails(ManageModuleStreamsInScheduledJobDetails manageModuleStreamsDetails) {
            this.manageModuleStreamsDetails = manageModuleStreamsDetails;
            this.__explicitlySet__.add("manageModuleStreamsDetails");
            return this;
        }

        public Builder switchModuleStreamsDetails(ModuleStreamDetails switchModuleStreamsDetails) {
            this.switchModuleStreamsDetails = switchModuleStreamsDetails;
            this.__explicitlySet__.add("switchModuleStreamsDetails");
            return this;
        }

        public Builder softwareSourceIds(List<String> softwareSourceIds) {
            this.softwareSourceIds = softwareSourceIds;
            this.__explicitlySet__.add("softwareSourceIds");
            return this;
        }

        public ScheduledJobOperation build() {
            ScheduledJobOperation model = new ScheduledJobOperation(this.operationType, this.packageNames, this.windowsUpdateNames, this.manageModuleStreamsDetails, this.switchModuleStreamsDetails, this.softwareSourceIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledJobOperation model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("packageNames")) {
                this.packageNames(model.getPackageNames());
            }
            if (model.wasPropertyExplicitlySet("windowsUpdateNames")) {
                this.windowsUpdateNames(model.getWindowsUpdateNames());
            }
            if (model.wasPropertyExplicitlySet("manageModuleStreamsDetails")) {
                this.manageModuleStreamsDetails(model.getManageModuleStreamsDetails());
            }
            if (model.wasPropertyExplicitlySet("switchModuleStreamsDetails")) {
                this.switchModuleStreamsDetails(model.getSwitchModuleStreamsDetails());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceIds")) {
                this.softwareSourceIds(model.getSoftwareSourceIds());
            }
            return this;
        }
    }
}

