/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ScheduleTypes;
import com.oracle.bmc.osmanagementhub.model.ScheduledJob;
import com.oracle.bmc.osmanagementhub.model.ScheduledJobOperation;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledJobSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="scheduleType")
    private final ScheduleTypes scheduleType;
    @JsonProperty(value="locations")
    private final List<ManagedInstanceLocation> locations;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeNextExecution")
    private final Date timeNextExecution;
    @JsonProperty(value="timeLastExecution")
    private final Date timeLastExecution;
    @JsonProperty(value="managedInstanceIds")
    private final List<String> managedInstanceIds;
    @JsonProperty(value="managedInstanceGroupIds")
    private final List<String> managedInstanceGroupIds;
    @JsonProperty(value="managedCompartmentIds")
    private final List<String> managedCompartmentIds;
    @JsonProperty(value="lifecycleStageIds")
    private final List<String> lifecycleStageIds;
    @JsonProperty(value="operations")
    private final List<ScheduledJobOperation> operations;
    @JsonProperty(value="lifecycleState")
    private final ScheduledJob.LifecycleState lifecycleState;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="isRestricted")
    private final Boolean isRestricted;
    @JsonProperty(value="retryIntervals")
    private final List<Integer> retryIntervals;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "scheduleType", "locations", "timeCreated", "timeUpdated", "timeNextExecution", "timeLastExecution", "managedInstanceIds", "managedInstanceGroupIds", "managedCompartmentIds", "lifecycleStageIds", "operations", "lifecycleState", "isManagedByAutonomousLinux", "freeformTags", "definedTags", "systemTags", "isRestricted", "retryIntervals"})
    public ScheduledJobSummary(String id, String displayName, String compartmentId, ScheduleTypes scheduleType, List<ManagedInstanceLocation> locations, Date timeCreated, Date timeUpdated, Date timeNextExecution, Date timeLastExecution, List<String> managedInstanceIds, List<String> managedInstanceGroupIds, List<String> managedCompartmentIds, List<String> lifecycleStageIds, List<ScheduledJobOperation> operations, ScheduledJob.LifecycleState lifecycleState, Boolean isManagedByAutonomousLinux, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Boolean isRestricted, List<Integer> retryIntervals) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.scheduleType = scheduleType;
        this.locations = locations;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeNextExecution = timeNextExecution;
        this.timeLastExecution = timeLastExecution;
        this.managedInstanceIds = managedInstanceIds;
        this.managedInstanceGroupIds = managedInstanceGroupIds;
        this.managedCompartmentIds = managedCompartmentIds;
        this.lifecycleStageIds = lifecycleStageIds;
        this.operations = operations;
        this.lifecycleState = lifecycleState;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.isRestricted = isRestricted;
        this.retryIntervals = retryIntervals;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ScheduleTypes getScheduleType() {
        return this.scheduleType;
    }

    public List<ManagedInstanceLocation> getLocations() {
        return this.locations;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeNextExecution() {
        return this.timeNextExecution;
    }

    public Date getTimeLastExecution() {
        return this.timeLastExecution;
    }

    public List<String> getManagedInstanceIds() {
        return this.managedInstanceIds;
    }

    public List<String> getManagedInstanceGroupIds() {
        return this.managedInstanceGroupIds;
    }

    public List<String> getManagedCompartmentIds() {
        return this.managedCompartmentIds;
    }

    public List<String> getLifecycleStageIds() {
        return this.lifecycleStageIds;
    }

    public List<ScheduledJobOperation> getOperations() {
        return this.operations;
    }

    public ScheduledJob.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Boolean getIsRestricted() {
        return this.isRestricted;
    }

    public List<Integer> getRetryIntervals() {
        return this.retryIntervals;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledJobSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(", locations=").append(String.valueOf(this.locations));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeNextExecution=").append(String.valueOf(this.timeNextExecution));
        sb.append(", timeLastExecution=").append(String.valueOf(this.timeLastExecution));
        sb.append(", managedInstanceIds=").append(String.valueOf(this.managedInstanceIds));
        sb.append(", managedInstanceGroupIds=").append(String.valueOf(this.managedInstanceGroupIds));
        sb.append(", managedCompartmentIds=").append(String.valueOf(this.managedCompartmentIds));
        sb.append(", lifecycleStageIds=").append(String.valueOf(this.lifecycleStageIds));
        sb.append(", operations=").append(String.valueOf(this.operations));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", isRestricted=").append(String.valueOf(this.isRestricted));
        sb.append(", retryIntervals=").append(String.valueOf(this.retryIntervals));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledJobSummary)) {
            return false;
        }
        ScheduledJobSummary other = (ScheduledJobSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.locations, other.locations) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeNextExecution, other.timeNextExecution) && Objects.equals(this.timeLastExecution, other.timeLastExecution) && Objects.equals(this.managedInstanceIds, other.managedInstanceIds) && Objects.equals(this.managedInstanceGroupIds, other.managedInstanceGroupIds) && Objects.equals(this.managedCompartmentIds, other.managedCompartmentIds) && Objects.equals(this.lifecycleStageIds, other.lifecycleStageIds) && Objects.equals(this.operations, other.operations) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.isRestricted, other.isRestricted) && Objects.equals(this.retryIntervals, other.retryIntervals) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.locations == null ? 43 : this.locations.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeNextExecution == null ? 43 : this.timeNextExecution.hashCode());
        result = result * 59 + (this.timeLastExecution == null ? 43 : this.timeLastExecution.hashCode());
        result = result * 59 + (this.managedInstanceIds == null ? 43 : this.managedInstanceIds.hashCode());
        result = result * 59 + (this.managedInstanceGroupIds == null ? 43 : this.managedInstanceGroupIds.hashCode());
        result = result * 59 + (this.managedCompartmentIds == null ? 43 : this.managedCompartmentIds.hashCode());
        result = result * 59 + (this.lifecycleStageIds == null ? 43 : this.lifecycleStageIds.hashCode());
        result = result * 59 + (this.operations == null ? 43 : this.operations.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.isRestricted == null ? 43 : this.isRestricted.hashCode());
        result = result * 59 + (this.retryIntervals == null ? 43 : this.retryIntervals.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="scheduleType")
        private ScheduleTypes scheduleType;
        @JsonProperty(value="locations")
        private List<ManagedInstanceLocation> locations;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeNextExecution")
        private Date timeNextExecution;
        @JsonProperty(value="timeLastExecution")
        private Date timeLastExecution;
        @JsonProperty(value="managedInstanceIds")
        private List<String> managedInstanceIds;
        @JsonProperty(value="managedInstanceGroupIds")
        private List<String> managedInstanceGroupIds;
        @JsonProperty(value="managedCompartmentIds")
        private List<String> managedCompartmentIds;
        @JsonProperty(value="lifecycleStageIds")
        private List<String> lifecycleStageIds;
        @JsonProperty(value="operations")
        private List<ScheduledJobOperation> operations;
        @JsonProperty(value="lifecycleState")
        private ScheduledJob.LifecycleState lifecycleState;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="isRestricted")
        private Boolean isRestricted;
        @JsonProperty(value="retryIntervals")
        private List<Integer> retryIntervals;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder scheduleType(ScheduleTypes scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder locations(List<ManagedInstanceLocation> locations) {
            this.locations = locations;
            this.__explicitlySet__.add("locations");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeNextExecution(Date timeNextExecution) {
            this.timeNextExecution = timeNextExecution;
            this.__explicitlySet__.add("timeNextExecution");
            return this;
        }

        public Builder timeLastExecution(Date timeLastExecution) {
            this.timeLastExecution = timeLastExecution;
            this.__explicitlySet__.add("timeLastExecution");
            return this;
        }

        public Builder managedInstanceIds(List<String> managedInstanceIds) {
            this.managedInstanceIds = managedInstanceIds;
            this.__explicitlySet__.add("managedInstanceIds");
            return this;
        }

        public Builder managedInstanceGroupIds(List<String> managedInstanceGroupIds) {
            this.managedInstanceGroupIds = managedInstanceGroupIds;
            this.__explicitlySet__.add("managedInstanceGroupIds");
            return this;
        }

        public Builder managedCompartmentIds(List<String> managedCompartmentIds) {
            this.managedCompartmentIds = managedCompartmentIds;
            this.__explicitlySet__.add("managedCompartmentIds");
            return this;
        }

        public Builder lifecycleStageIds(List<String> lifecycleStageIds) {
            this.lifecycleStageIds = lifecycleStageIds;
            this.__explicitlySet__.add("lifecycleStageIds");
            return this;
        }

        public Builder operations(List<ScheduledJobOperation> operations) {
            this.operations = operations;
            this.__explicitlySet__.add("operations");
            return this;
        }

        public Builder lifecycleState(ScheduledJob.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            this.__explicitlySet__.add("isRestricted");
            return this;
        }

        public Builder retryIntervals(List<Integer> retryIntervals) {
            this.retryIntervals = retryIntervals;
            this.__explicitlySet__.add("retryIntervals");
            return this;
        }

        public ScheduledJobSummary build() {
            ScheduledJobSummary model = new ScheduledJobSummary(this.id, this.displayName, this.compartmentId, this.scheduleType, this.locations, this.timeCreated, this.timeUpdated, this.timeNextExecution, this.timeLastExecution, this.managedInstanceIds, this.managedInstanceGroupIds, this.managedCompartmentIds, this.lifecycleStageIds, this.operations, this.lifecycleState, this.isManagedByAutonomousLinux, this.freeformTags, this.definedTags, this.systemTags, this.isRestricted, this.retryIntervals);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledJobSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("scheduleType")) {
                this.scheduleType(model.getScheduleType());
            }
            if (model.wasPropertyExplicitlySet("locations")) {
                this.locations(model.getLocations());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeNextExecution")) {
                this.timeNextExecution(model.getTimeNextExecution());
            }
            if (model.wasPropertyExplicitlySet("timeLastExecution")) {
                this.timeLastExecution(model.getTimeLastExecution());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceIds")) {
                this.managedInstanceIds(model.getManagedInstanceIds());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceGroupIds")) {
                this.managedInstanceGroupIds(model.getManagedInstanceGroupIds());
            }
            if (model.wasPropertyExplicitlySet("managedCompartmentIds")) {
                this.managedCompartmentIds(model.getManagedCompartmentIds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStageIds")) {
                this.lifecycleStageIds(model.getLifecycleStageIds());
            }
            if (model.wasPropertyExplicitlySet("operations")) {
                this.operations(model.getOperations());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("isRestricted")) {
                this.isRestricted(model.getIsRestricted());
            }
            if (model.wasPropertyExplicitlySet("retryIntervals")) {
                this.retryIntervals(model.getRetryIntervals());
            }
            return this;
        }
    }
}

