/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.Availability;
import com.oracle.bmc.osmanagementhub.model.ChecksumType;
import com.oracle.bmc.osmanagementhub.model.CustomSoftwareSource;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.VendorSoftwareSource;
import com.oracle.bmc.osmanagementhub.model.VersionedCustomSoftwareSource;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="softwareSourceType", defaultImpl=SoftwareSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=VendorSoftwareSource.class, name="VENDOR"), @JsonSubTypes.Type(value=CustomSoftwareSource.class, name="CUSTOM"), @JsonSubTypes.Type(value=VersionedCustomSoftwareSource.class, name="VERSIONED")})
@JsonFilter(value="explicitlySetFilter")
public class SoftwareSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="availability")
    private final Availability availability;
    @JsonProperty(value="availabilityAtOci")
    private final Availability availabilityAtOci;
    @JsonProperty(value="repoId")
    private final String repoId;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="archType")
    private final ArchType archType;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="packageCount")
    private final Long packageCount;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="checksumType")
    private final ChecksumType checksumType;
    @JsonProperty(value="gpgKeyUrl")
    private final String gpgKeyUrl;
    @JsonProperty(value="gpgKeyId")
    private final String gpgKeyId;
    @JsonProperty(value="gpgKeyFingerprint")
    private final String gpgKeyFingerprint;
    @JsonProperty(value="size")
    private final Double size;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "timeCreated", "description", "availability", "availabilityAtOci", "repoId", "osFamily", "archType", "lifecycleState", "packageCount", "url", "checksumType", "gpgKeyUrl", "gpgKeyId", "gpgKeyFingerprint", "size", "freeformTags", "definedTags", "systemTags"})
    protected SoftwareSource(String id, String compartmentId, String displayName, Date timeCreated, String description, Availability availability, Availability availabilityAtOci, String repoId, OsFamily osFamily, ArchType archType, LifecycleState lifecycleState, Long packageCount, String url, ChecksumType checksumType, String gpgKeyUrl, String gpgKeyId, String gpgKeyFingerprint, Double size, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.description = description;
        this.availability = availability;
        this.availabilityAtOci = availabilityAtOci;
        this.repoId = repoId;
        this.osFamily = osFamily;
        this.archType = archType;
        this.lifecycleState = lifecycleState;
        this.packageCount = packageCount;
        this.url = url;
        this.checksumType = checksumType;
        this.gpgKeyUrl = gpgKeyUrl;
        this.gpgKeyId = gpgKeyId;
        this.gpgKeyFingerprint = gpgKeyFingerprint;
        this.size = size;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getDescription() {
        return this.description;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public Availability getAvailabilityAtOci() {
        return this.availabilityAtOci;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ArchType getArchType() {
        return this.archType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Long getPackageCount() {
        return this.packageCount;
    }

    public String getUrl() {
        return this.url;
    }

    public ChecksumType getChecksumType() {
        return this.checksumType;
    }

    public String getGpgKeyUrl() {
        return this.gpgKeyUrl;
    }

    public String getGpgKeyId() {
        return this.gpgKeyId;
    }

    public String getGpgKeyFingerprint() {
        return this.gpgKeyFingerprint;
    }

    public Double getSize() {
        return this.size;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwareSource(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", availability=").append(String.valueOf((Object)this.availability));
        sb.append(", availabilityAtOci=").append(String.valueOf((Object)this.availabilityAtOci));
        sb.append(", repoId=").append(String.valueOf(this.repoId));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", archType=").append(String.valueOf((Object)this.archType));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", packageCount=").append(String.valueOf(this.packageCount));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", checksumType=").append(String.valueOf((Object)this.checksumType));
        sb.append(", gpgKeyUrl=").append(String.valueOf(this.gpgKeyUrl));
        sb.append(", gpgKeyId=").append(String.valueOf(this.gpgKeyId));
        sb.append(", gpgKeyFingerprint=").append(String.valueOf(this.gpgKeyFingerprint));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareSource)) {
            return false;
        }
        SoftwareSource other = (SoftwareSource)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.availability, (Object)other.availability) && Objects.equals((Object)this.availabilityAtOci, (Object)other.availabilityAtOci) && Objects.equals(this.repoId, other.repoId) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.packageCount, other.packageCount) && Objects.equals(this.url, other.url) && Objects.equals((Object)this.checksumType, (Object)other.checksumType) && Objects.equals(this.gpgKeyUrl, other.gpgKeyUrl) && Objects.equals(this.gpgKeyId, other.gpgKeyId) && Objects.equals(this.gpgKeyFingerprint, other.gpgKeyFingerprint) && Objects.equals(this.size, other.size) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.availability == null ? 43 : this.availability.hashCode());
        result = result * 59 + (this.availabilityAtOci == null ? 43 : this.availabilityAtOci.hashCode());
        result = result * 59 + (this.repoId == null ? 43 : this.repoId.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.packageCount == null ? 43 : this.packageCount.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.checksumType == null ? 43 : this.checksumType.hashCode());
        result = result * 59 + (this.gpgKeyUrl == null ? 43 : this.gpgKeyUrl.hashCode());
        result = result * 59 + (this.gpgKeyId == null ? 43 : this.gpgKeyId.hashCode());
        result = result * 59 + (this.gpgKeyFingerprint == null ? 43 : this.gpgKeyFingerprint.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

