/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.EventStatus;
import com.oracle.bmc.osmanagementhub.model.WorkRequestEventDataAdditionalDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SoftwareSourceEventData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="status")
    private final EventStatus status;
    @JsonProperty(value="additionalDetails")
    private final WorkRequestEventDataAdditionalDetails additionalDetails;

    @Deprecated
    @ConstructorProperties(value={"operationType", "status", "additionalDetails"})
    public SoftwareSourceEventData(OperationType operationType, EventStatus status, WorkRequestEventDataAdditionalDetails additionalDetails) {
        this.operationType = operationType;
        this.status = status;
        this.additionalDetails = additionalDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public WorkRequestEventDataAdditionalDetails getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwareSourceEventData(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", additionalDetails=").append(String.valueOf((Object)this.additionalDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareSourceEventData)) {
            return false;
        }
        SoftwareSourceEventData other = (SoftwareSourceEventData)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.additionalDetails, (Object)other.additionalDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationType implements BmcEnum
    {
        EnableModuleStreams("ENABLE_MODULE_STREAMS"),
        DisableModuleStreams("DISABLE_MODULE_STREAMS"),
        SwitchModuleStream("SWITCH_MODULE_STREAM"),
        InstallModuleProfile("INSTALL_MODULE_PROFILE"),
        RemoveModuleProfiles("REMOVE_MODULE_PROFILES"),
        SetSoftwareSources("SET_SOFTWARE_SOURCES"),
        UpdateSoftwareSource("UPDATE_SOFTWARE_SOURCE"),
        CreateSoftwareSource("CREATE_SOFTWARE_SOURCE"),
        LifecyclePromotion("LIFECYCLE_PROMOTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="status")
        private EventStatus status;
        @JsonProperty(value="additionalDetails")
        private WorkRequestEventDataAdditionalDetails additionalDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder status(EventStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder additionalDetails(WorkRequestEventDataAdditionalDetails additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.__explicitlySet__.add("additionalDetails");
            return this;
        }

        public SoftwareSourceEventData build() {
            SoftwareSourceEventData model = new SoftwareSourceEventData(this.operationType, this.status, this.additionalDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SoftwareSourceEventData model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("additionalDetails")) {
                this.additionalDetails(model.getAdditionalDetails());
            }
            return this;
        }
    }
}

