/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SoftwareSourceVendorSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final VendorName name;
    @JsonProperty(value="osFamilies")
    private final List<OsFamily> osFamilies;
    @JsonProperty(value="archTypes")
    private final List<ArchType> archTypes;

    @Deprecated
    @ConstructorProperties(value={"name", "osFamilies", "archTypes"})
    public SoftwareSourceVendorSummary(VendorName name, List<OsFamily> osFamilies, List<ArchType> archTypes) {
        this.name = name;
        this.osFamilies = osFamilies;
        this.archTypes = archTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public VendorName getName() {
        return this.name;
    }

    public List<OsFamily> getOsFamilies() {
        return this.osFamilies;
    }

    public List<ArchType> getArchTypes() {
        return this.archTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwareSourceVendorSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf((Object)this.name));
        sb.append(", osFamilies=").append(String.valueOf(this.osFamilies));
        sb.append(", archTypes=").append(String.valueOf(this.archTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareSourceVendorSummary)) {
            return false;
        }
        SoftwareSourceVendorSummary other = (SoftwareSourceVendorSummary)((Object)o);
        return Objects.equals((Object)this.name, (Object)other.name) && Objects.equals(this.osFamilies, other.osFamilies) && Objects.equals(this.archTypes, other.archTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.osFamilies == null ? 43 : this.osFamilies.hashCode());
        result = result * 59 + (this.archTypes == null ? 43 : this.archTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private VendorName name;
        @JsonProperty(value="osFamilies")
        private List<OsFamily> osFamilies;
        @JsonProperty(value="archTypes")
        private List<ArchType> archTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(VendorName name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder osFamilies(List<OsFamily> osFamilies) {
            this.osFamilies = osFamilies;
            this.__explicitlySet__.add("osFamilies");
            return this;
        }

        public Builder archTypes(List<ArchType> archTypes) {
            this.archTypes = archTypes;
            this.__explicitlySet__.add("archTypes");
            return this;
        }

        public SoftwareSourceVendorSummary build() {
            SoftwareSourceVendorSummary model = new SoftwareSourceVendorSummary(this.name, this.osFamilies, this.archTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SoftwareSourceVendorSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("osFamilies")) {
                this.osFamilies(model.getOsFamilies());
            }
            if (model.wasPropertyExplicitlySet("archTypes")) {
                this.archTypes(model.getArchTypes());
            }
            return this;
        }
    }
}

