/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.Event;
import com.oracle.bmc.osmanagementhub.model.SoftwareUpdateEventData;
import com.oracle.bmc.osmanagementhub.model.SystemDetails;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SoftwareUpdateEvent
extends Event {
    @JsonProperty(value="data")
    private final SoftwareUpdateEventData data;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SoftwareUpdateEvent(String id, String eventSummary, String compartmentId, String eventDetails, String resourceId, SystemDetails systemDetails, Date timeOccurred, Date timeCreated, Date timeUpdated, Event.LifecycleState lifecycleState, String lifecycleDetails, Boolean isManagedByAutonomousLinux, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, SoftwareUpdateEventData data) {
        super(id, eventSummary, compartmentId, eventDetails, resourceId, systemDetails, timeOccurred, timeCreated, timeUpdated, lifecycleState, lifecycleDetails, isManagedByAutonomousLinux, freeformTags, definedTags, systemTags);
        this.data = data;
    }

    public SoftwareUpdateEventData getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoftwareUpdateEvent(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", data=").append(String.valueOf((Object)this.data));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareUpdateEvent)) {
            return false;
        }
        SoftwareUpdateEvent other = (SoftwareUpdateEvent)((Object)o);
        return Objects.equals((Object)this.data, (Object)other.data) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.data == null ? 43 : this.data.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="eventSummary")
        private String eventSummary;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="eventDetails")
        private String eventDetails;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="systemDetails")
        private SystemDetails systemDetails;
        @JsonProperty(value="timeOccurred")
        private Date timeOccurred;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private Event.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="data")
        private SoftwareUpdateEventData data;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder eventSummary(String eventSummary) {
            this.eventSummary = eventSummary;
            this.__explicitlySet__.add("eventSummary");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder eventDetails(String eventDetails) {
            this.eventDetails = eventDetails;
            this.__explicitlySet__.add("eventDetails");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder systemDetails(SystemDetails systemDetails) {
            this.systemDetails = systemDetails;
            this.__explicitlySet__.add("systemDetails");
            return this;
        }

        public Builder timeOccurred(Date timeOccurred) {
            this.timeOccurred = timeOccurred;
            this.__explicitlySet__.add("timeOccurred");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(Event.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder data(SoftwareUpdateEventData data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public SoftwareUpdateEvent build() {
            SoftwareUpdateEvent model = new SoftwareUpdateEvent(this.id, this.eventSummary, this.compartmentId, this.eventDetails, this.resourceId, this.systemDetails, this.timeOccurred, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.isManagedByAutonomousLinux, this.freeformTags, this.definedTags, this.systemTags, this.data);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SoftwareUpdateEvent model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("eventSummary")) {
                this.eventSummary(model.getEventSummary());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("eventDetails")) {
                this.eventDetails(model.getEventDetails());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("systemDetails")) {
                this.systemDetails(model.getSystemDetails());
            }
            if (model.wasPropertyExplicitlySet("timeOccurred")) {
                this.timeOccurred(model.getTimeOccurred());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            return this;
        }
    }
}

