/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.PackageSummary;
import com.oracle.bmc.osmanagementhub.model.SoftwareSourceDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="packageClassification")
@JsonFilter(value="explicitlySetFilter")
public final class UpdatablePackageSummary
extends PackageSummary {
    @JsonProperty(value="installedVersion")
    private final String installedVersion;
    @JsonProperty(value="updateType")
    private final ClassificationTypes updateType;
    @JsonProperty(value="errata")
    private final List<String> errata;
    @JsonProperty(value="relatedCves")
    private final List<String> relatedCves;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdatablePackageSummary(String displayName, String name, String type, String version, ArchType architecture, List<SoftwareSourceDetails> softwareSources, String installedVersion, ClassificationTypes updateType, List<String> errata, List<String> relatedCves) {
        super(displayName, name, type, version, architecture, softwareSources);
        this.installedVersion = installedVersion;
        this.updateType = updateType;
        this.errata = errata;
        this.relatedCves = relatedCves;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public ClassificationTypes getUpdateType() {
        return this.updateType;
    }

    public List<String> getErrata() {
        return this.errata;
    }

    public List<String> getRelatedCves() {
        return this.relatedCves;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdatablePackageSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", installedVersion=").append(String.valueOf(this.installedVersion));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", errata=").append(String.valueOf(this.errata));
        sb.append(", relatedCves=").append(String.valueOf(this.relatedCves));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatablePackageSummary)) {
            return false;
        }
        UpdatablePackageSummary other = (UpdatablePackageSummary)((Object)o);
        return Objects.equals(this.installedVersion, other.installedVersion) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.errata, other.errata) && Objects.equals(this.relatedCves, other.relatedCves) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.installedVersion == null ? 43 : this.installedVersion.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.errata == null ? 43 : this.errata.hashCode());
        result = result * 59 + (this.relatedCves == null ? 43 : this.relatedCves.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="architecture")
        private ArchType architecture;
        @JsonProperty(value="softwareSources")
        private List<SoftwareSourceDetails> softwareSources;
        @JsonProperty(value="installedVersion")
        private String installedVersion;
        @JsonProperty(value="updateType")
        private ClassificationTypes updateType;
        @JsonProperty(value="errata")
        private List<String> errata;
        @JsonProperty(value="relatedCves")
        private List<String> relatedCves;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder architecture(ArchType architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder softwareSources(List<SoftwareSourceDetails> softwareSources) {
            this.softwareSources = softwareSources;
            this.__explicitlySet__.add("softwareSources");
            return this;
        }

        public Builder installedVersion(String installedVersion) {
            this.installedVersion = installedVersion;
            this.__explicitlySet__.add("installedVersion");
            return this;
        }

        public Builder updateType(ClassificationTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder errata(List<String> errata) {
            this.errata = errata;
            this.__explicitlySet__.add("errata");
            return this;
        }

        public Builder relatedCves(List<String> relatedCves) {
            this.relatedCves = relatedCves;
            this.__explicitlySet__.add("relatedCves");
            return this;
        }

        public UpdatablePackageSummary build() {
            UpdatablePackageSummary model = new UpdatablePackageSummary(this.displayName, this.name, this.type, this.version, this.architecture, this.softwareSources, this.installedVersion, this.updateType, this.errata, this.relatedCves);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdatablePackageSummary model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("softwareSources")) {
                this.softwareSources(model.getSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("installedVersion")) {
                this.installedVersion(model.getInstalledVersion());
            }
            if (model.wasPropertyExplicitlySet("updateType")) {
                this.updateType(model.getUpdateType());
            }
            if (model.wasPropertyExplicitlySet("errata")) {
                this.errata(model.getErrata());
            }
            if (model.wasPropertyExplicitlySet("relatedCves")) {
                this.relatedCves(model.getRelatedCves());
            }
            return this;
        }
    }
}

