/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.CustomSoftwareSourceFilter;
import com.oracle.bmc.osmanagementhub.model.Id;
import com.oracle.bmc.osmanagementhub.model.UpdateSoftwareSourceDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="softwareSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateCustomSoftwareSourceDetails
extends UpdateSoftwareSourceDetails {
    @JsonProperty(value="vendorSoftwareSources")
    private final List<Id> vendorSoftwareSources;
    @JsonProperty(value="customSoftwareSourceFilter")
    private final CustomSoftwareSourceFilter customSoftwareSourceFilter;
    @JsonProperty(value="isAutomaticallyUpdated")
    private final Boolean isAutomaticallyUpdated;
    @JsonProperty(value="isAutoResolveDependencies")
    private final Boolean isAutoResolveDependencies;
    @JsonProperty(value="isLatestContentOnly")
    private final Boolean isLatestContentOnly;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateCustomSoftwareSourceDetails(String compartmentId, String displayName, String description, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<Id> vendorSoftwareSources, CustomSoftwareSourceFilter customSoftwareSourceFilter, Boolean isAutomaticallyUpdated, Boolean isAutoResolveDependencies, Boolean isLatestContentOnly) {
        super(compartmentId, displayName, description, freeformTags, definedTags);
        this.vendorSoftwareSources = vendorSoftwareSources;
        this.customSoftwareSourceFilter = customSoftwareSourceFilter;
        this.isAutomaticallyUpdated = isAutomaticallyUpdated;
        this.isAutoResolveDependencies = isAutoResolveDependencies;
        this.isLatestContentOnly = isLatestContentOnly;
    }

    public List<Id> getVendorSoftwareSources() {
        return this.vendorSoftwareSources;
    }

    public CustomSoftwareSourceFilter getCustomSoftwareSourceFilter() {
        return this.customSoftwareSourceFilter;
    }

    public Boolean getIsAutomaticallyUpdated() {
        return this.isAutomaticallyUpdated;
    }

    public Boolean getIsAutoResolveDependencies() {
        return this.isAutoResolveDependencies;
    }

    public Boolean getIsLatestContentOnly() {
        return this.isLatestContentOnly;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateCustomSoftwareSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vendorSoftwareSources=").append(String.valueOf(this.vendorSoftwareSources));
        sb.append(", customSoftwareSourceFilter=").append(String.valueOf((Object)this.customSoftwareSourceFilter));
        sb.append(", isAutomaticallyUpdated=").append(String.valueOf(this.isAutomaticallyUpdated));
        sb.append(", isAutoResolveDependencies=").append(String.valueOf(this.isAutoResolveDependencies));
        sb.append(", isLatestContentOnly=").append(String.valueOf(this.isLatestContentOnly));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCustomSoftwareSourceDetails)) {
            return false;
        }
        UpdateCustomSoftwareSourceDetails other = (UpdateCustomSoftwareSourceDetails)((Object)o);
        return Objects.equals(this.vendorSoftwareSources, other.vendorSoftwareSources) && Objects.equals((Object)this.customSoftwareSourceFilter, (Object)other.customSoftwareSourceFilter) && Objects.equals(this.isAutomaticallyUpdated, other.isAutomaticallyUpdated) && Objects.equals(this.isAutoResolveDependencies, other.isAutoResolveDependencies) && Objects.equals(this.isLatestContentOnly, other.isLatestContentOnly) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vendorSoftwareSources == null ? 43 : this.vendorSoftwareSources.hashCode());
        result = result * 59 + (this.customSoftwareSourceFilter == null ? 43 : this.customSoftwareSourceFilter.hashCode());
        result = result * 59 + (this.isAutomaticallyUpdated == null ? 43 : this.isAutomaticallyUpdated.hashCode());
        result = result * 59 + (this.isAutoResolveDependencies == null ? 43 : this.isAutoResolveDependencies.hashCode());
        result = result * 59 + (this.isLatestContentOnly == null ? 43 : this.isLatestContentOnly.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="vendorSoftwareSources")
        private List<Id> vendorSoftwareSources;
        @JsonProperty(value="customSoftwareSourceFilter")
        private CustomSoftwareSourceFilter customSoftwareSourceFilter;
        @JsonProperty(value="isAutomaticallyUpdated")
        private Boolean isAutomaticallyUpdated;
        @JsonProperty(value="isAutoResolveDependencies")
        private Boolean isAutoResolveDependencies;
        @JsonProperty(value="isLatestContentOnly")
        private Boolean isLatestContentOnly;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder vendorSoftwareSources(List<Id> vendorSoftwareSources) {
            this.vendorSoftwareSources = vendorSoftwareSources;
            this.__explicitlySet__.add("vendorSoftwareSources");
            return this;
        }

        public Builder customSoftwareSourceFilter(CustomSoftwareSourceFilter customSoftwareSourceFilter) {
            this.customSoftwareSourceFilter = customSoftwareSourceFilter;
            this.__explicitlySet__.add("customSoftwareSourceFilter");
            return this;
        }

        public Builder isAutomaticallyUpdated(Boolean isAutomaticallyUpdated) {
            this.isAutomaticallyUpdated = isAutomaticallyUpdated;
            this.__explicitlySet__.add("isAutomaticallyUpdated");
            return this;
        }

        public Builder isAutoResolveDependencies(Boolean isAutoResolveDependencies) {
            this.isAutoResolveDependencies = isAutoResolveDependencies;
            this.__explicitlySet__.add("isAutoResolveDependencies");
            return this;
        }

        public Builder isLatestContentOnly(Boolean isLatestContentOnly) {
            this.isLatestContentOnly = isLatestContentOnly;
            this.__explicitlySet__.add("isLatestContentOnly");
            return this;
        }

        public UpdateCustomSoftwareSourceDetails build() {
            UpdateCustomSoftwareSourceDetails model = new UpdateCustomSoftwareSourceDetails(this.compartmentId, this.displayName, this.description, this.freeformTags, this.definedTags, this.vendorSoftwareSources, this.customSoftwareSourceFilter, this.isAutomaticallyUpdated, this.isAutoResolveDependencies, this.isLatestContentOnly);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateCustomSoftwareSourceDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("vendorSoftwareSources")) {
                this.vendorSoftwareSources(model.getVendorSoftwareSources());
            }
            if (model.wasPropertyExplicitlySet("customSoftwareSourceFilter")) {
                this.customSoftwareSourceFilter(model.getCustomSoftwareSourceFilter());
            }
            if (model.wasPropertyExplicitlySet("isAutomaticallyUpdated")) {
                this.isAutomaticallyUpdated(model.getIsAutomaticallyUpdated());
            }
            if (model.wasPropertyExplicitlySet("isAutoResolveDependencies")) {
                this.isAutoResolveDependencies(model.getIsAutoResolveDependencies());
            }
            if (model.wasPropertyExplicitlySet("isLatestContentOnly")) {
                this.isLatestContentOnly(model.getIsLatestContentOnly());
            }
            return this;
        }
    }
}

