/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.UpdateTypes;
import com.oracle.bmc.osmanagementhub.model.WorkRequestDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdatePackagesOnManagedInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="packageNames")
    private final List<String> packageNames;
    @JsonProperty(value="updateTypes")
    private final List<UpdateTypes> updateTypes;
    @JsonProperty(value="workRequestDetails")
    private final WorkRequestDetails workRequestDetails;

    @Deprecated
    @ConstructorProperties(value={"packageNames", "updateTypes", "workRequestDetails"})
    public UpdatePackagesOnManagedInstanceDetails(List<String> packageNames, List<UpdateTypes> updateTypes, WorkRequestDetails workRequestDetails) {
        this.packageNames = packageNames;
        this.updateTypes = updateTypes;
        this.workRequestDetails = workRequestDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public List<UpdateTypes> getUpdateTypes() {
        return this.updateTypes;
    }

    public WorkRequestDetails getWorkRequestDetails() {
        return this.workRequestDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdatePackagesOnManagedInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("packageNames=").append(String.valueOf(this.packageNames));
        sb.append(", updateTypes=").append(String.valueOf(this.updateTypes));
        sb.append(", workRequestDetails=").append(String.valueOf((Object)this.workRequestDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePackagesOnManagedInstanceDetails)) {
            return false;
        }
        UpdatePackagesOnManagedInstanceDetails other = (UpdatePackagesOnManagedInstanceDetails)((Object)o);
        return Objects.equals(this.packageNames, other.packageNames) && Objects.equals(this.updateTypes, other.updateTypes) && Objects.equals((Object)this.workRequestDetails, (Object)other.workRequestDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.packageNames == null ? 43 : this.packageNames.hashCode());
        result = result * 59 + (this.updateTypes == null ? 43 : this.updateTypes.hashCode());
        result = result * 59 + (this.workRequestDetails == null ? 43 : this.workRequestDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="packageNames")
        private List<String> packageNames;
        @JsonProperty(value="updateTypes")
        private List<UpdateTypes> updateTypes;
        @JsonProperty(value="workRequestDetails")
        private WorkRequestDetails workRequestDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder packageNames(List<String> packageNames) {
            this.packageNames = packageNames;
            this.__explicitlySet__.add("packageNames");
            return this;
        }

        public Builder updateTypes(List<UpdateTypes> updateTypes) {
            this.updateTypes = updateTypes;
            this.__explicitlySet__.add("updateTypes");
            return this;
        }

        public Builder workRequestDetails(WorkRequestDetails workRequestDetails) {
            this.workRequestDetails = workRequestDetails;
            this.__explicitlySet__.add("workRequestDetails");
            return this;
        }

        public UpdatePackagesOnManagedInstanceDetails build() {
            UpdatePackagesOnManagedInstanceDetails model = new UpdatePackagesOnManagedInstanceDetails(this.packageNames, this.updateTypes, this.workRequestDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdatePackagesOnManagedInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("packageNames")) {
                this.packageNames(model.getPackageNames());
            }
            if (model.wasPropertyExplicitlySet("updateTypes")) {
                this.updateTypes(model.getUpdateTypes());
            }
            if (model.wasPropertyExplicitlySet("workRequestDetails")) {
                this.workRequestDetails(model.getWorkRequestDetails());
            }
            return this;
        }
    }
}

