/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.ScheduleTypes;
import com.oracle.bmc.osmanagementhub.model.ScheduledJobOperation;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateScheduledJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="scheduleType")
    private final ScheduleTypes scheduleType;
    @JsonProperty(value="timeNextExecution")
    private final Date timeNextExecution;
    @JsonProperty(value="recurringRule")
    private final String recurringRule;
    @JsonProperty(value="operations")
    private final List<ScheduledJobOperation> operations;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="retryIntervals")
    private final List<Integer> retryIntervals;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "scheduleType", "timeNextExecution", "recurringRule", "operations", "freeformTags", "definedTags", "retryIntervals"})
    public UpdateScheduledJobDetails(String displayName, String description, ScheduleTypes scheduleType, Date timeNextExecution, String recurringRule, List<ScheduledJobOperation> operations, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<Integer> retryIntervals) {
        this.displayName = displayName;
        this.description = description;
        this.scheduleType = scheduleType;
        this.timeNextExecution = timeNextExecution;
        this.recurringRule = recurringRule;
        this.operations = operations;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.retryIntervals = retryIntervals;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ScheduleTypes getScheduleType() {
        return this.scheduleType;
    }

    public Date getTimeNextExecution() {
        return this.timeNextExecution;
    }

    public String getRecurringRule() {
        return this.recurringRule;
    }

    public List<ScheduledJobOperation> getOperations() {
        return this.operations;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<Integer> getRetryIntervals() {
        return this.retryIntervals;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateScheduledJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(", timeNextExecution=").append(String.valueOf(this.timeNextExecution));
        sb.append(", recurringRule=").append(String.valueOf(this.recurringRule));
        sb.append(", operations=").append(String.valueOf(this.operations));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", retryIntervals=").append(String.valueOf(this.retryIntervals));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateScheduledJobDetails)) {
            return false;
        }
        UpdateScheduledJobDetails other = (UpdateScheduledJobDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.timeNextExecution, other.timeNextExecution) && Objects.equals(this.recurringRule, other.recurringRule) && Objects.equals(this.operations, other.operations) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.retryIntervals, other.retryIntervals) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.timeNextExecution == null ? 43 : this.timeNextExecution.hashCode());
        result = result * 59 + (this.recurringRule == null ? 43 : this.recurringRule.hashCode());
        result = result * 59 + (this.operations == null ? 43 : this.operations.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.retryIntervals == null ? 43 : this.retryIntervals.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="scheduleType")
        private ScheduleTypes scheduleType;
        @JsonProperty(value="timeNextExecution")
        private Date timeNextExecution;
        @JsonProperty(value="recurringRule")
        private String recurringRule;
        @JsonProperty(value="operations")
        private List<ScheduledJobOperation> operations;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="retryIntervals")
        private List<Integer> retryIntervals;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder scheduleType(ScheduleTypes scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder timeNextExecution(Date timeNextExecution) {
            this.timeNextExecution = timeNextExecution;
            this.__explicitlySet__.add("timeNextExecution");
            return this;
        }

        public Builder recurringRule(String recurringRule) {
            this.recurringRule = recurringRule;
            this.__explicitlySet__.add("recurringRule");
            return this;
        }

        public Builder operations(List<ScheduledJobOperation> operations) {
            this.operations = operations;
            this.__explicitlySet__.add("operations");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder retryIntervals(List<Integer> retryIntervals) {
            this.retryIntervals = retryIntervals;
            this.__explicitlySet__.add("retryIntervals");
            return this;
        }

        public UpdateScheduledJobDetails build() {
            UpdateScheduledJobDetails model = new UpdateScheduledJobDetails(this.displayName, this.description, this.scheduleType, this.timeNextExecution, this.recurringRule, this.operations, this.freeformTags, this.definedTags, this.retryIntervals);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateScheduledJobDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("scheduleType")) {
                this.scheduleType(model.getScheduleType());
            }
            if (model.wasPropertyExplicitlySet("timeNextExecution")) {
                this.timeNextExecution(model.getTimeNextExecution());
            }
            if (model.wasPropertyExplicitlySet("recurringRule")) {
                this.recurringRule(model.getRecurringRule());
            }
            if (model.wasPropertyExplicitlySet("operations")) {
                this.operations(model.getOperations());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("retryIntervals")) {
                this.retryIntervals(model.getRetryIntervals());
            }
            return this;
        }
    }
}

