/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.Availability;
import com.oracle.bmc.osmanagementhub.model.ChecksumType;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SoftwareSource;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="softwareSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class VendorSoftwareSource
extends SoftwareSource {
    @JsonProperty(value="vendorName")
    private final VendorName vendorName;
    @JsonProperty(value="originSoftwareSourceId")
    private final String originSoftwareSourceId;
    @JsonProperty(value="isMandatoryForAutonomousLinux")
    private final Boolean isMandatoryForAutonomousLinux;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VendorSoftwareSource(String id, String compartmentId, String displayName, Date timeCreated, String description, Availability availability, Availability availabilityAtOci, String repoId, OsFamily osFamily, ArchType archType, SoftwareSource.LifecycleState lifecycleState, Long packageCount, String url, ChecksumType checksumType, String gpgKeyUrl, String gpgKeyId, String gpgKeyFingerprint, Double size, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, VendorName vendorName, String originSoftwareSourceId, Boolean isMandatoryForAutonomousLinux) {
        super(id, compartmentId, displayName, timeCreated, description, availability, availabilityAtOci, repoId, osFamily, archType, lifecycleState, packageCount, url, checksumType, gpgKeyUrl, gpgKeyId, gpgKeyFingerprint, size, freeformTags, definedTags, systemTags);
        this.vendorName = vendorName;
        this.originSoftwareSourceId = originSoftwareSourceId;
        this.isMandatoryForAutonomousLinux = isMandatoryForAutonomousLinux;
    }

    public VendorName getVendorName() {
        return this.vendorName;
    }

    public String getOriginSoftwareSourceId() {
        return this.originSoftwareSourceId;
    }

    public Boolean getIsMandatoryForAutonomousLinux() {
        return this.isMandatoryForAutonomousLinux;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VendorSoftwareSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", vendorName=").append(String.valueOf((Object)this.vendorName));
        sb.append(", originSoftwareSourceId=").append(String.valueOf(this.originSoftwareSourceId));
        sb.append(", isMandatoryForAutonomousLinux=").append(String.valueOf(this.isMandatoryForAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VendorSoftwareSource)) {
            return false;
        }
        VendorSoftwareSource other = (VendorSoftwareSource)((Object)o);
        return Objects.equals((Object)this.vendorName, (Object)other.vendorName) && Objects.equals(this.originSoftwareSourceId, other.originSoftwareSourceId) && Objects.equals(this.isMandatoryForAutonomousLinux, other.isMandatoryForAutonomousLinux) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.originSoftwareSourceId == null ? 43 : this.originSoftwareSourceId.hashCode());
        result = result * 59 + (this.isMandatoryForAutonomousLinux == null ? 43 : this.isMandatoryForAutonomousLinux.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="availability")
        private Availability availability;
        @JsonProperty(value="availabilityAtOci")
        private Availability availabilityAtOci;
        @JsonProperty(value="repoId")
        private String repoId;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="archType")
        private ArchType archType;
        @JsonProperty(value="lifecycleState")
        private SoftwareSource.LifecycleState lifecycleState;
        @JsonProperty(value="packageCount")
        private Long packageCount;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="checksumType")
        private ChecksumType checksumType;
        @JsonProperty(value="gpgKeyUrl")
        private String gpgKeyUrl;
        @JsonProperty(value="gpgKeyId")
        private String gpgKeyId;
        @JsonProperty(value="gpgKeyFingerprint")
        private String gpgKeyFingerprint;
        @JsonProperty(value="size")
        private Double size;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="vendorName")
        private VendorName vendorName;
        @JsonProperty(value="originSoftwareSourceId")
        private String originSoftwareSourceId;
        @JsonProperty(value="isMandatoryForAutonomousLinux")
        private Boolean isMandatoryForAutonomousLinux;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder availability(Availability availability) {
            this.availability = availability;
            this.__explicitlySet__.add("availability");
            return this;
        }

        public Builder availabilityAtOci(Availability availabilityAtOci) {
            this.availabilityAtOci = availabilityAtOci;
            this.__explicitlySet__.add("availabilityAtOci");
            return this;
        }

        public Builder repoId(String repoId) {
            this.repoId = repoId;
            this.__explicitlySet__.add("repoId");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder archType(ArchType archType) {
            this.archType = archType;
            this.__explicitlySet__.add("archType");
            return this;
        }

        public Builder lifecycleState(SoftwareSource.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder packageCount(Long packageCount) {
            this.packageCount = packageCount;
            this.__explicitlySet__.add("packageCount");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder checksumType(ChecksumType checksumType) {
            this.checksumType = checksumType;
            this.__explicitlySet__.add("checksumType");
            return this;
        }

        public Builder gpgKeyUrl(String gpgKeyUrl) {
            this.gpgKeyUrl = gpgKeyUrl;
            this.__explicitlySet__.add("gpgKeyUrl");
            return this;
        }

        public Builder gpgKeyId(String gpgKeyId) {
            this.gpgKeyId = gpgKeyId;
            this.__explicitlySet__.add("gpgKeyId");
            return this;
        }

        public Builder gpgKeyFingerprint(String gpgKeyFingerprint) {
            this.gpgKeyFingerprint = gpgKeyFingerprint;
            this.__explicitlySet__.add("gpgKeyFingerprint");
            return this;
        }

        public Builder size(Double size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder vendorName(VendorName vendorName) {
            this.vendorName = vendorName;
            this.__explicitlySet__.add("vendorName");
            return this;
        }

        public Builder originSoftwareSourceId(String originSoftwareSourceId) {
            this.originSoftwareSourceId = originSoftwareSourceId;
            this.__explicitlySet__.add("originSoftwareSourceId");
            return this;
        }

        public Builder isMandatoryForAutonomousLinux(Boolean isMandatoryForAutonomousLinux) {
            this.isMandatoryForAutonomousLinux = isMandatoryForAutonomousLinux;
            this.__explicitlySet__.add("isMandatoryForAutonomousLinux");
            return this;
        }

        public VendorSoftwareSource build() {
            VendorSoftwareSource model = new VendorSoftwareSource(this.id, this.compartmentId, this.displayName, this.timeCreated, this.description, this.availability, this.availabilityAtOci, this.repoId, this.osFamily, this.archType, this.lifecycleState, this.packageCount, this.url, this.checksumType, this.gpgKeyUrl, this.gpgKeyId, this.gpgKeyFingerprint, this.size, this.freeformTags, this.definedTags, this.systemTags, this.vendorName, this.originSoftwareSourceId, this.isMandatoryForAutonomousLinux);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VendorSoftwareSource model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("availability")) {
                this.availability(model.getAvailability());
            }
            if (model.wasPropertyExplicitlySet("availabilityAtOci")) {
                this.availabilityAtOci(model.getAvailabilityAtOci());
            }
            if (model.wasPropertyExplicitlySet("repoId")) {
                this.repoId(model.getRepoId());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("archType")) {
                this.archType(model.getArchType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("packageCount")) {
                this.packageCount(model.getPackageCount());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("checksumType")) {
                this.checksumType(model.getChecksumType());
            }
            if (model.wasPropertyExplicitlySet("gpgKeyUrl")) {
                this.gpgKeyUrl(model.getGpgKeyUrl());
            }
            if (model.wasPropertyExplicitlySet("gpgKeyId")) {
                this.gpgKeyId(model.getGpgKeyId());
            }
            if (model.wasPropertyExplicitlySet("gpgKeyFingerprint")) {
                this.gpgKeyFingerprint(model.getGpgKeyFingerprint());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("vendorName")) {
                this.vendorName(model.getVendorName());
            }
            if (model.wasPropertyExplicitlySet("originSoftwareSourceId")) {
                this.originSoftwareSourceId(model.getOriginSoftwareSourceId());
            }
            if (model.wasPropertyExplicitlySet("isMandatoryForAutonomousLinux")) {
                this.isMandatoryForAutonomousLinux(model.getIsMandatoryForAutonomousLinux());
            }
            return this;
        }
    }
}

