/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.InstallationRequirements;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WindowsUpdate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="updateId")
    private final String updateId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="updateType")
    private final ClassificationTypes updateType;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="installable")
    private final Installable installable;
    @JsonProperty(value="installationRequirements")
    private final List<InstallationRequirements> installationRequirements;
    @JsonProperty(value="isRebootRequiredForInstallation")
    private final Boolean isRebootRequiredForInstallation;
    @JsonProperty(value="kbArticleIds")
    private final List<String> kbArticleIds;

    @Deprecated
    @ConstructorProperties(value={"name", "updateId", "description", "updateType", "sizeInBytes", "installable", "installationRequirements", "isRebootRequiredForInstallation", "kbArticleIds"})
    public WindowsUpdate(String name, String updateId, String description, ClassificationTypes updateType, Long sizeInBytes, Installable installable, List<InstallationRequirements> installationRequirements, Boolean isRebootRequiredForInstallation, List<String> kbArticleIds) {
        this.name = name;
        this.updateId = updateId;
        this.description = description;
        this.updateType = updateType;
        this.sizeInBytes = sizeInBytes;
        this.installable = installable;
        this.installationRequirements = installationRequirements;
        this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
        this.kbArticleIds = kbArticleIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getUpdateId() {
        return this.updateId;
    }

    public String getDescription() {
        return this.description;
    }

    public ClassificationTypes getUpdateType() {
        return this.updateType;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Installable getInstallable() {
        return this.installable;
    }

    public List<InstallationRequirements> getInstallationRequirements() {
        return this.installationRequirements;
    }

    public Boolean getIsRebootRequiredForInstallation() {
        return this.isRebootRequiredForInstallation;
    }

    public List<String> getKbArticleIds() {
        return this.kbArticleIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WindowsUpdate(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", updateId=").append(String.valueOf(this.updateId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", installable=").append(String.valueOf((Object)this.installable));
        sb.append(", installationRequirements=").append(String.valueOf(this.installationRequirements));
        sb.append(", isRebootRequiredForInstallation=").append(String.valueOf(this.isRebootRequiredForInstallation));
        sb.append(", kbArticleIds=").append(String.valueOf(this.kbArticleIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowsUpdate)) {
            return false;
        }
        WindowsUpdate other = (WindowsUpdate)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.updateId, other.updateId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals((Object)this.installable, (Object)other.installable) && Objects.equals(this.installationRequirements, other.installationRequirements) && Objects.equals(this.isRebootRequiredForInstallation, other.isRebootRequiredForInstallation) && Objects.equals(this.kbArticleIds, other.kbArticleIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.updateId == null ? 43 : this.updateId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.installable == null ? 43 : this.installable.hashCode());
        result = result * 59 + (this.installationRequirements == null ? 43 : this.installationRequirements.hashCode());
        result = result * 59 + (this.isRebootRequiredForInstallation == null ? 43 : this.isRebootRequiredForInstallation.hashCode());
        result = result * 59 + (this.kbArticleIds == null ? 43 : this.kbArticleIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Installable implements BmcEnum
    {
        Installable("INSTALLABLE"),
        NotInstallable("NOT_INSTALLABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Installable> map;

        private Installable(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Installable create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Installable', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Installable.class);
            map = new HashMap<String, Installable>();
            for (Installable v : Installable.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="updateId")
        private String updateId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="updateType")
        private ClassificationTypes updateType;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="installable")
        private Installable installable;
        @JsonProperty(value="installationRequirements")
        private List<InstallationRequirements> installationRequirements;
        @JsonProperty(value="isRebootRequiredForInstallation")
        private Boolean isRebootRequiredForInstallation;
        @JsonProperty(value="kbArticleIds")
        private List<String> kbArticleIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder updateId(String updateId) {
            this.updateId = updateId;
            this.__explicitlySet__.add("updateId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder updateType(ClassificationTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder installable(Installable installable) {
            this.installable = installable;
            this.__explicitlySet__.add("installable");
            return this;
        }

        public Builder installationRequirements(List<InstallationRequirements> installationRequirements) {
            this.installationRequirements = installationRequirements;
            this.__explicitlySet__.add("installationRequirements");
            return this;
        }

        public Builder isRebootRequiredForInstallation(Boolean isRebootRequiredForInstallation) {
            this.isRebootRequiredForInstallation = isRebootRequiredForInstallation;
            this.__explicitlySet__.add("isRebootRequiredForInstallation");
            return this;
        }

        public Builder kbArticleIds(List<String> kbArticleIds) {
            this.kbArticleIds = kbArticleIds;
            this.__explicitlySet__.add("kbArticleIds");
            return this;
        }

        public WindowsUpdate build() {
            WindowsUpdate model = new WindowsUpdate(this.name, this.updateId, this.description, this.updateType, this.sizeInBytes, this.installable, this.installationRequirements, this.isRebootRequiredForInstallation, this.kbArticleIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WindowsUpdate model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("updateId")) {
                this.updateId(model.getUpdateId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("updateType")) {
                this.updateType(model.getUpdateType());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("installable")) {
                this.installable(model.getInstallable());
            }
            if (model.wasPropertyExplicitlySet("installationRequirements")) {
                this.installationRequirements(model.getInstallationRequirements());
            }
            if (model.wasPropertyExplicitlySet("isRebootRequiredForInstallation")) {
                this.isRebootRequiredForInstallation(model.getIsRebootRequiredForInstallation());
            }
            if (model.wasPropertyExplicitlySet("kbArticleIds")) {
                this.kbArticleIds(model.getKbArticleIds());
            }
            return this;
        }
    }
}

