/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestManagementStationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managementStationVersion")
    private final String managementStationVersion;
    @JsonProperty(value="config")
    private final byte[] config;
    @JsonProperty(value="softwareSourceIds")
    private final List<String> softwareSourceIds;

    @Deprecated
    @ConstructorProperties(value={"managementStationVersion", "config", "softwareSourceIds"})
    public WorkRequestManagementStationDetails(String managementStationVersion, byte[] config, List<String> softwareSourceIds) {
        this.managementStationVersion = managementStationVersion;
        this.config = config;
        this.softwareSourceIds = softwareSourceIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagementStationVersion() {
        return this.managementStationVersion;
    }

    public byte[] getConfig() {
        return this.config;
    }

    public List<String> getSoftwareSourceIds() {
        return this.softwareSourceIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestManagementStationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("managementStationVersion=").append(String.valueOf(this.managementStationVersion));
        sb.append(", config=").append(includeByteArrayContents ? Arrays.toString(this.config) : String.valueOf(this.config) + (this.config != null ? " (byte[" + this.config.length + "])" : ""));
        sb.append(", softwareSourceIds=").append(String.valueOf(this.softwareSourceIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestManagementStationDetails)) {
            return false;
        }
        WorkRequestManagementStationDetails other = (WorkRequestManagementStationDetails)((Object)o);
        return Objects.equals(this.managementStationVersion, other.managementStationVersion) && Arrays.equals(this.config, other.config) && Objects.equals(this.softwareSourceIds, other.softwareSourceIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managementStationVersion == null ? 43 : this.managementStationVersion.hashCode());
        result = result * 59 + Arrays.hashCode(this.config);
        result = result * 59 + (this.softwareSourceIds == null ? 43 : this.softwareSourceIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managementStationVersion")
        private String managementStationVersion;
        @JsonProperty(value="config")
        private byte[] config;
        @JsonProperty(value="softwareSourceIds")
        private List<String> softwareSourceIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managementStationVersion(String managementStationVersion) {
            this.managementStationVersion = managementStationVersion;
            this.__explicitlySet__.add("managementStationVersion");
            return this;
        }

        public Builder config(byte[] config) {
            this.config = config;
            this.__explicitlySet__.add("config");
            return this;
        }

        public Builder softwareSourceIds(List<String> softwareSourceIds) {
            this.softwareSourceIds = softwareSourceIds;
            this.__explicitlySet__.add("softwareSourceIds");
            return this;
        }

        public WorkRequestManagementStationDetails build() {
            WorkRequestManagementStationDetails model = new WorkRequestManagementStationDetails(this.managementStationVersion, this.config, this.softwareSourceIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestManagementStationDetails model) {
            if (model.wasPropertyExplicitlySet("managementStationVersion")) {
                this.managementStationVersion(model.getManagementStationVersion());
            }
            if (model.wasPropertyExplicitlySet("config")) {
                this.config(model.getConfig());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceIds")) {
                this.softwareSourceIds(model.getSoftwareSourceIds());
            }
            return this;
        }
    }
}

