/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagementhub.model.OperationStatus;
import com.oracle.bmc.osmanagementhub.model.WorkRequestOperationType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final WorkRequestOperationType operationType;
    @JsonProperty(value="status")
    private final OperationStatus status;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="parentId")
    private final String parentId;
    @JsonProperty(value="childrenId")
    private final List<String> childrenId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeScheduled")
    private final Date timeScheduled;
    @JsonProperty(value="isManagedByAutonomousLinux")
    private final Boolean isManagedByAutonomousLinux;

    @Deprecated
    @ConstructorProperties(value={"operationType", "status", "id", "description", "displayName", "message", "parentId", "childrenId", "compartmentId", "percentComplete", "timeCreated", "timeScheduled", "isManagedByAutonomousLinux"})
    public WorkRequestSummary(WorkRequestOperationType operationType, OperationStatus status, String id, String description, String displayName, String message, String parentId, List<String> childrenId, String compartmentId, Float percentComplete, Date timeCreated, Date timeScheduled, Boolean isManagedByAutonomousLinux) {
        this.operationType = operationType;
        this.status = status;
        this.id = id;
        this.description = description;
        this.displayName = displayName;
        this.message = message;
        this.parentId = parentId;
        this.childrenId = childrenId;
        this.compartmentId = compartmentId;
        this.percentComplete = percentComplete;
        this.timeCreated = timeCreated;
        this.timeScheduled = timeScheduled;
        this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public WorkRequestOperationType getOperationType() {
        return this.operationType;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<String> getChildrenId() {
        return this.childrenId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeScheduled() {
        return this.timeScheduled;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", parentId=").append(String.valueOf(this.parentId));
        sb.append(", childrenId=").append(String.valueOf(this.childrenId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeScheduled=").append(String.valueOf(this.timeScheduled));
        sb.append(", isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestSummary)) {
            return false;
        }
        WorkRequestSummary other = (WorkRequestSummary)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.id, other.id) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.message, other.message) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.childrenId, other.childrenId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeScheduled, other.timeScheduled) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.childrenId == null ? 43 : this.childrenId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeScheduled == null ? 43 : this.timeScheduled.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private WorkRequestOperationType operationType;
        @JsonProperty(value="status")
        private OperationStatus status;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="childrenId")
        private List<String> childrenId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeScheduled")
        private Date timeScheduled;
        @JsonProperty(value="isManagedByAutonomousLinux")
        private Boolean isManagedByAutonomousLinux;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(WorkRequestOperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.__explicitlySet__.add("parentId");
            return this;
        }

        public Builder childrenId(List<String> childrenId) {
            this.childrenId = childrenId;
            this.__explicitlySet__.add("childrenId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeScheduled(Date timeScheduled) {
            this.timeScheduled = timeScheduled;
            this.__explicitlySet__.add("timeScheduled");
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            this.__explicitlySet__.add("isManagedByAutonomousLinux");
            return this;
        }

        public WorkRequestSummary build() {
            WorkRequestSummary model = new WorkRequestSummary(this.operationType, this.status, this.id, this.description, this.displayName, this.message, this.parentId, this.childrenId, this.compartmentId, this.percentComplete, this.timeCreated, this.timeScheduled, this.isManagedByAutonomousLinux);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestSummary model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("parentId")) {
                this.parentId(model.getParentId());
            }
            if (model.wasPropertyExplicitlySet("childrenId")) {
                this.childrenId(model.getChildrenId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeScheduled")) {
                this.timeScheduled(model.getTimeScheduled());
            }
            if (model.wasPropertyExplicitlySet("isManagedByAutonomousLinux")) {
                this.isManagedByAutonomousLinux(model.getIsManagedByAutonomousLinux());
            }
            return this;
        }
    }
}

