/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLifecycleEnvironmentRequest
extends BmcRequest<Void> {
    private String lifecycleEnvironmentId;
    private String opcRequestId;

    public String getLifecycleEnvironmentId() {
        return this.lifecycleEnvironmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().lifecycleEnvironmentId(this.lifecycleEnvironmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",lifecycleEnvironmentId=").append(String.valueOf(this.lifecycleEnvironmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLifecycleEnvironmentRequest)) {
            return false;
        }
        GetLifecycleEnvironmentRequest other = (GetLifecycleEnvironmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.lifecycleEnvironmentId, other.lifecycleEnvironmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.lifecycleEnvironmentId == null ? 43 : this.lifecycleEnvironmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLifecycleEnvironmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String lifecycleEnvironmentId = null;
        private String opcRequestId = null;

        public Builder lifecycleEnvironmentId(String lifecycleEnvironmentId) {
            this.lifecycleEnvironmentId = lifecycleEnvironmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLifecycleEnvironmentRequest o) {
            this.lifecycleEnvironmentId(o.getLifecycleEnvironmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLifecycleEnvironmentRequest build() {
            GetLifecycleEnvironmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLifecycleEnvironmentRequest buildWithoutInvocationCallback() {
            GetLifecycleEnvironmentRequest request = new GetLifecycleEnvironmentRequest();
            request.lifecycleEnvironmentId = this.lifecycleEnvironmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

