/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceStatus;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetManagedInstanceAnalyticContentRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String managedInstanceGroupId;
    private String lifecycleEnvironmentId;
    private String lifecycleStageId;
    private List<ManagedInstanceStatus> status;
    private List<String> displayName;
    private String displayNameContains;
    private Integer securityUpdatesAvailableEqualsTo;
    private Integer bugUpdatesAvailableEqualsTo;
    private Integer securityUpdatesAvailableGreaterThan;
    private Integer bugUpdatesAvailableGreaterThan;
    private List<ManagedInstanceLocation> location;
    private List<ManagedInstanceLocation> locationNotEqualTo;
    private List<OsFamily> osFamily;
    private Boolean isManagedByAutonomousLinux;
    private ReportFormat reportFormat;
    private ReportType reportType;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public String getLifecycleEnvironmentId() {
        return this.lifecycleEnvironmentId;
    }

    public String getLifecycleStageId() {
        return this.lifecycleStageId;
    }

    public List<ManagedInstanceStatus> getStatus() {
        return this.status;
    }

    public List<String> getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public Integer getSecurityUpdatesAvailableEqualsTo() {
        return this.securityUpdatesAvailableEqualsTo;
    }

    public Integer getBugUpdatesAvailableEqualsTo() {
        return this.bugUpdatesAvailableEqualsTo;
    }

    public Integer getSecurityUpdatesAvailableGreaterThan() {
        return this.securityUpdatesAvailableGreaterThan;
    }

    public Integer getBugUpdatesAvailableGreaterThan() {
        return this.bugUpdatesAvailableGreaterThan;
    }

    public List<ManagedInstanceLocation> getLocation() {
        return this.location;
    }

    public List<ManagedInstanceLocation> getLocationNotEqualTo() {
        return this.locationNotEqualTo;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).managedInstanceGroupId(this.managedInstanceGroupId).lifecycleEnvironmentId(this.lifecycleEnvironmentId).lifecycleStageId(this.lifecycleStageId).status(this.status).displayName(this.displayName).displayNameContains(this.displayNameContains).securityUpdatesAvailableEqualsTo(this.securityUpdatesAvailableEqualsTo).bugUpdatesAvailableEqualsTo(this.bugUpdatesAvailableEqualsTo).securityUpdatesAvailableGreaterThan(this.securityUpdatesAvailableGreaterThan).bugUpdatesAvailableGreaterThan(this.bugUpdatesAvailableGreaterThan).location(this.location).locationNotEqualTo(this.locationNotEqualTo).osFamily(this.osFamily).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux).reportFormat(this.reportFormat).reportType(this.reportType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",managedInstanceGroupId=").append(String.valueOf(this.managedInstanceGroupId));
        sb.append(",lifecycleEnvironmentId=").append(String.valueOf(this.lifecycleEnvironmentId));
        sb.append(",lifecycleStageId=").append(String.valueOf(this.lifecycleStageId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",securityUpdatesAvailableEqualsTo=").append(String.valueOf(this.securityUpdatesAvailableEqualsTo));
        sb.append(",bugUpdatesAvailableEqualsTo=").append(String.valueOf(this.bugUpdatesAvailableEqualsTo));
        sb.append(",securityUpdatesAvailableGreaterThan=").append(String.valueOf(this.securityUpdatesAvailableGreaterThan));
        sb.append(",bugUpdatesAvailableGreaterThan=").append(String.valueOf(this.bugUpdatesAvailableGreaterThan));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",locationNotEqualTo=").append(String.valueOf(this.locationNotEqualTo));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",reportType=").append(String.valueOf((Object)this.reportType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagedInstanceAnalyticContentRequest)) {
            return false;
        }
        GetManagedInstanceAnalyticContentRequest other = (GetManagedInstanceAnalyticContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.managedInstanceGroupId, other.managedInstanceGroupId) && Objects.equals(this.lifecycleEnvironmentId, other.lifecycleEnvironmentId) && Objects.equals(this.lifecycleStageId, other.lifecycleStageId) && Objects.equals(this.status, other.status) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.securityUpdatesAvailableEqualsTo, other.securityUpdatesAvailableEqualsTo) && Objects.equals(this.bugUpdatesAvailableEqualsTo, other.bugUpdatesAvailableEqualsTo) && Objects.equals(this.securityUpdatesAvailableGreaterThan, other.securityUpdatesAvailableGreaterThan) && Objects.equals(this.bugUpdatesAvailableGreaterThan, other.bugUpdatesAvailableGreaterThan) && Objects.equals(this.location, other.location) && Objects.equals(this.locationNotEqualTo, other.locationNotEqualTo) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals((Object)this.reportType, (Object)other.reportType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.managedInstanceGroupId == null ? 43 : this.managedInstanceGroupId.hashCode());
        result = result * 59 + (this.lifecycleEnvironmentId == null ? 43 : this.lifecycleEnvironmentId.hashCode());
        result = result * 59 + (this.lifecycleStageId == null ? 43 : this.lifecycleStageId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.securityUpdatesAvailableEqualsTo == null ? 43 : this.securityUpdatesAvailableEqualsTo.hashCode());
        result = result * 59 + (this.bugUpdatesAvailableEqualsTo == null ? 43 : this.bugUpdatesAvailableEqualsTo.hashCode());
        result = result * 59 + (this.securityUpdatesAvailableGreaterThan == null ? 43 : this.securityUpdatesAvailableGreaterThan.hashCode());
        result = result * 59 + (this.bugUpdatesAvailableGreaterThan == null ? 43 : this.bugUpdatesAvailableGreaterThan.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.locationNotEqualTo == null ? 43 : this.locationNotEqualTo.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.reportType == null ? 43 : this.reportType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedInstanceAnalyticContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String managedInstanceGroupId = null;
        private String lifecycleEnvironmentId = null;
        private String lifecycleStageId = null;
        private List<ManagedInstanceStatus> status = null;
        private List<String> displayName = null;
        private String displayNameContains = null;
        private Integer securityUpdatesAvailableEqualsTo = null;
        private Integer bugUpdatesAvailableEqualsTo = null;
        private Integer securityUpdatesAvailableGreaterThan = null;
        private Integer bugUpdatesAvailableGreaterThan = null;
        private List<ManagedInstanceLocation> location = null;
        private List<ManagedInstanceLocation> locationNotEqualTo = null;
        private List<OsFamily> osFamily = null;
        private Boolean isManagedByAutonomousLinux = null;
        private ReportFormat reportFormat = null;
        private ReportType reportType = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder lifecycleEnvironmentId(String lifecycleEnvironmentId) {
            this.lifecycleEnvironmentId = lifecycleEnvironmentId;
            return this;
        }

        public Builder lifecycleStageId(String lifecycleStageId) {
            this.lifecycleStageId = lifecycleStageId;
            return this;
        }

        public Builder status(List<ManagedInstanceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ManagedInstanceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder displayName(List<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String singularValue) {
            return this.displayName(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder securityUpdatesAvailableEqualsTo(Integer securityUpdatesAvailableEqualsTo) {
            this.securityUpdatesAvailableEqualsTo = securityUpdatesAvailableEqualsTo;
            return this;
        }

        public Builder bugUpdatesAvailableEqualsTo(Integer bugUpdatesAvailableEqualsTo) {
            this.bugUpdatesAvailableEqualsTo = bugUpdatesAvailableEqualsTo;
            return this;
        }

        public Builder securityUpdatesAvailableGreaterThan(Integer securityUpdatesAvailableGreaterThan) {
            this.securityUpdatesAvailableGreaterThan = securityUpdatesAvailableGreaterThan;
            return this;
        }

        public Builder bugUpdatesAvailableGreaterThan(Integer bugUpdatesAvailableGreaterThan) {
            this.bugUpdatesAvailableGreaterThan = bugUpdatesAvailableGreaterThan;
            return this;
        }

        public Builder location(List<ManagedInstanceLocation> location) {
            this.location = location;
            return this;
        }

        public Builder location(ManagedInstanceLocation singularValue) {
            return this.location(Arrays.asList(singularValue));
        }

        public Builder locationNotEqualTo(List<ManagedInstanceLocation> locationNotEqualTo) {
            this.locationNotEqualTo = locationNotEqualTo;
            return this;
        }

        public Builder locationNotEqualTo(ManagedInstanceLocation singularValue) {
            return this.locationNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder reportType(ReportType reportType) {
            this.reportType = reportType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedInstanceAnalyticContentRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.lifecycleEnvironmentId(o.getLifecycleEnvironmentId());
            this.lifecycleStageId(o.getLifecycleStageId());
            this.status(o.getStatus());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.securityUpdatesAvailableEqualsTo(o.getSecurityUpdatesAvailableEqualsTo());
            this.bugUpdatesAvailableEqualsTo(o.getBugUpdatesAvailableEqualsTo());
            this.securityUpdatesAvailableGreaterThan(o.getSecurityUpdatesAvailableGreaterThan());
            this.bugUpdatesAvailableGreaterThan(o.getBugUpdatesAvailableGreaterThan());
            this.location(o.getLocation());
            this.locationNotEqualTo(o.getLocationNotEqualTo());
            this.osFamily(o.getOsFamily());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.reportFormat(o.getReportFormat());
            this.reportType(o.getReportType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedInstanceAnalyticContentRequest build() {
            GetManagedInstanceAnalyticContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetManagedInstanceAnalyticContentRequest buildWithoutInvocationCallback() {
            GetManagedInstanceAnalyticContentRequest request = new GetManagedInstanceAnalyticContentRequest();
            request.compartmentId = this.compartmentId;
            request.managedInstanceGroupId = this.managedInstanceGroupId;
            request.lifecycleEnvironmentId = this.lifecycleEnvironmentId;
            request.lifecycleStageId = this.lifecycleStageId;
            request.status = this.status;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.securityUpdatesAvailableEqualsTo = this.securityUpdatesAvailableEqualsTo;
            request.bugUpdatesAvailableEqualsTo = this.bugUpdatesAvailableEqualsTo;
            request.securityUpdatesAvailableGreaterThan = this.securityUpdatesAvailableGreaterThan;
            request.bugUpdatesAvailableGreaterThan = this.bugUpdatesAvailableGreaterThan;
            request.location = this.location;
            request.locationNotEqualTo = this.locationNotEqualTo;
            request.osFamily = this.osFamily;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            request.reportFormat = this.reportFormat;
            request.reportType = this.reportType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ReportType implements BmcEnum
    {
        Security("SECURITY"),
        Bugfix("BUGFIX"),
        Activity("ACTIVITY"),
        All("ALL");

        private final String value;
        private static Map<String, ReportType> map;

        private ReportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportType: " + key);
        }

        static {
            map = new HashMap<String, ReportType>();
            for (ReportType v : ReportType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ReportFormat implements BmcEnum
    {
        Csv("csv"),
        Json("json"),
        Xml("xml");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

