/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.AdvisoryTypes;
import com.oracle.bmc.osmanagementhub.model.VulnerabilityTypes;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetManagedInstanceContentRequest
extends BmcRequest<Void> {
    private String managedInstanceId;
    private List<VulnerabilityTypes> vulnerabilityType;
    private List<String> advisoryName;
    private String advisoryNameContains;
    private List<AdvisoryTypes> advisoryType;
    private List<String> vulnerabilityName;
    private String vulnerabilityNameContains;
    private ReportFormat reportFormat;
    private String opcRequestId;

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public List<VulnerabilityTypes> getVulnerabilityType() {
        return this.vulnerabilityType;
    }

    public List<String> getAdvisoryName() {
        return this.advisoryName;
    }

    public String getAdvisoryNameContains() {
        return this.advisoryNameContains;
    }

    public List<AdvisoryTypes> getAdvisoryType() {
        return this.advisoryType;
    }

    public List<String> getVulnerabilityName() {
        return this.vulnerabilityName;
    }

    public String getVulnerabilityNameContains() {
        return this.vulnerabilityNameContains;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedInstanceId(this.managedInstanceId).vulnerabilityType(this.vulnerabilityType).advisoryName(this.advisoryName).advisoryNameContains(this.advisoryNameContains).advisoryType(this.advisoryType).vulnerabilityName(this.vulnerabilityName).vulnerabilityNameContains(this.vulnerabilityNameContains).reportFormat(this.reportFormat).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",vulnerabilityType=").append(String.valueOf(this.vulnerabilityType));
        sb.append(",advisoryName=").append(String.valueOf(this.advisoryName));
        sb.append(",advisoryNameContains=").append(String.valueOf(this.advisoryNameContains));
        sb.append(",advisoryType=").append(String.valueOf(this.advisoryType));
        sb.append(",vulnerabilityName=").append(String.valueOf(this.vulnerabilityName));
        sb.append(",vulnerabilityNameContains=").append(String.valueOf(this.vulnerabilityNameContains));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagedInstanceContentRequest)) {
            return false;
        }
        GetManagedInstanceContentRequest other = (GetManagedInstanceContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.vulnerabilityType, other.vulnerabilityType) && Objects.equals(this.advisoryName, other.advisoryName) && Objects.equals(this.advisoryNameContains, other.advisoryNameContains) && Objects.equals(this.advisoryType, other.advisoryType) && Objects.equals(this.vulnerabilityName, other.vulnerabilityName) && Objects.equals(this.vulnerabilityNameContains, other.vulnerabilityNameContains) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result = result * 59 + (this.advisoryName == null ? 43 : this.advisoryName.hashCode());
        result = result * 59 + (this.advisoryNameContains == null ? 43 : this.advisoryNameContains.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + (this.vulnerabilityName == null ? 43 : this.vulnerabilityName.hashCode());
        result = result * 59 + (this.vulnerabilityNameContains == null ? 43 : this.vulnerabilityNameContains.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedInstanceContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedInstanceId = null;
        private List<VulnerabilityTypes> vulnerabilityType = null;
        private List<String> advisoryName = null;
        private String advisoryNameContains = null;
        private List<AdvisoryTypes> advisoryType = null;
        private List<String> vulnerabilityName = null;
        private String vulnerabilityNameContains = null;
        private ReportFormat reportFormat = null;
        private String opcRequestId = null;

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder vulnerabilityType(List<VulnerabilityTypes> vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            return this;
        }

        public Builder vulnerabilityType(VulnerabilityTypes singularValue) {
            return this.vulnerabilityType(Arrays.asList(singularValue));
        }

        public Builder advisoryName(List<String> advisoryName) {
            this.advisoryName = advisoryName;
            return this;
        }

        public Builder advisoryName(String singularValue) {
            return this.advisoryName(Arrays.asList(singularValue));
        }

        public Builder advisoryNameContains(String advisoryNameContains) {
            this.advisoryNameContains = advisoryNameContains;
            return this;
        }

        public Builder advisoryType(List<AdvisoryTypes> advisoryType) {
            this.advisoryType = advisoryType;
            return this;
        }

        public Builder advisoryType(AdvisoryTypes singularValue) {
            return this.advisoryType(Arrays.asList(singularValue));
        }

        public Builder vulnerabilityName(List<String> vulnerabilityName) {
            this.vulnerabilityName = vulnerabilityName;
            return this;
        }

        public Builder vulnerabilityName(String singularValue) {
            return this.vulnerabilityName(Arrays.asList(singularValue));
        }

        public Builder vulnerabilityNameContains(String vulnerabilityNameContains) {
            this.vulnerabilityNameContains = vulnerabilityNameContains;
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedInstanceContentRequest o) {
            this.managedInstanceId(o.getManagedInstanceId());
            this.vulnerabilityType(o.getVulnerabilityType());
            this.advisoryName(o.getAdvisoryName());
            this.advisoryNameContains(o.getAdvisoryNameContains());
            this.advisoryType(o.getAdvisoryType());
            this.vulnerabilityName(o.getVulnerabilityName());
            this.vulnerabilityNameContains(o.getVulnerabilityNameContains());
            this.reportFormat(o.getReportFormat());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedInstanceContentRequest build() {
            GetManagedInstanceContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetManagedInstanceContentRequest buildWithoutInvocationCallback() {
            GetManagedInstanceContentRequest request = new GetManagedInstanceContentRequest();
            request.managedInstanceId = this.managedInstanceId;
            request.vulnerabilityType = this.vulnerabilityType;
            request.advisoryName = this.advisoryName;
            request.advisoryNameContains = this.advisoryNameContains;
            request.advisoryType = this.advisoryType;
            request.vulnerabilityName = this.vulnerabilityName;
            request.vulnerabilityNameContains = this.vulnerabilityNameContains;
            request.reportFormat = this.reportFormat;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ReportFormat implements BmcEnum
    {
        Csv("csv"),
        Json("json"),
        Xml("xml");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

