/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPackageGroupRequest
extends BmcRequest<Void> {
    private String softwareSourceId;
    private String packageGroupId;
    private String opcRequestId;

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public String getPackageGroupId() {
        return this.packageGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().softwareSourceId(this.softwareSourceId).packageGroupId(this.packageGroupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(",packageGroupId=").append(String.valueOf(this.packageGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPackageGroupRequest)) {
            return false;
        }
        GetPackageGroupRequest other = (GetPackageGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals(this.packageGroupId, other.packageGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.packageGroupId == null ? 43 : this.packageGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPackageGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String softwareSourceId = null;
        private String packageGroupId = null;
        private String opcRequestId = null;

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder packageGroupId(String packageGroupId) {
            this.packageGroupId = packageGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPackageGroupRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.packageGroupId(o.getPackageGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPackageGroupRequest build() {
            GetPackageGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPackageGroupRequest buildWithoutInvocationCallback() {
            GetPackageGroupRequest request = new GetPackageGroupRequest();
            request.softwareSourceId = this.softwareSourceId;
            request.packageGroupId = this.packageGroupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

