/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSoftwarePackageByNameRequest
extends BmcRequest<Void> {
    private String softwarePackageName;
    private String opcRequestId;

    public String getSoftwarePackageName() {
        return this.softwarePackageName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().softwarePackageName(this.softwarePackageName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",softwarePackageName=").append(String.valueOf(this.softwarePackageName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSoftwarePackageByNameRequest)) {
            return false;
        }
        GetSoftwarePackageByNameRequest other = (GetSoftwarePackageByNameRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.softwarePackageName, other.softwarePackageName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.softwarePackageName == null ? 43 : this.softwarePackageName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSoftwarePackageByNameRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String softwarePackageName = null;
        private String opcRequestId = null;

        public Builder softwarePackageName(String softwarePackageName) {
            this.softwarePackageName = softwarePackageName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSoftwarePackageByNameRequest o) {
            this.softwarePackageName(o.getSoftwarePackageName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSoftwarePackageByNameRequest build() {
            GetSoftwarePackageByNameRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSoftwarePackageByNameRequest buildWithoutInvocationCallback() {
            GetSoftwarePackageByNameRequest request = new GetSoftwarePackageByNameRequest();
            request.softwarePackageName = this.softwarePackageName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

