/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWindowsUpdateRequest
extends BmcRequest<Void> {
    private String windowsUpdateId;
    private String opcRequestId;

    public String getWindowsUpdateId() {
        return this.windowsUpdateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().windowsUpdateId(this.windowsUpdateId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",windowsUpdateId=").append(String.valueOf(this.windowsUpdateId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWindowsUpdateRequest)) {
            return false;
        }
        GetWindowsUpdateRequest other = (GetWindowsUpdateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.windowsUpdateId, other.windowsUpdateId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.windowsUpdateId == null ? 43 : this.windowsUpdateId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWindowsUpdateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String windowsUpdateId = null;
        private String opcRequestId = null;

        public Builder windowsUpdateId(String windowsUpdateId) {
            this.windowsUpdateId = windowsUpdateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWindowsUpdateRequest o) {
            this.windowsUpdateId(o.getWindowsUpdateId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWindowsUpdateRequest build() {
            GetWindowsUpdateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWindowsUpdateRequest buildWithoutInvocationCallback() {
            GetWindowsUpdateRequest request = new GetWindowsUpdateRequest();
            request.windowsUpdateId = this.windowsUpdateId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

