/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.AdvisorySeverity;
import com.oracle.bmc.osmanagementhub.model.AdvisoryTypes;
import com.oracle.bmc.osmanagementhub.model.ClassificationTypes;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListErrataRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> name;
    private String nameContains;
    private List<ClassificationTypes> classificationType;
    private List<AdvisoryTypes> advisoryType;
    private OsFamily osFamily;
    private List<AdvisorySeverity> advisorySeverity;
    private Date timeIssueDateStart;
    private Date timeIssueDateEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getName() {
        return this.name;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public List<ClassificationTypes> getClassificationType() {
        return this.classificationType;
    }

    public List<AdvisoryTypes> getAdvisoryType() {
        return this.advisoryType;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public List<AdvisorySeverity> getAdvisorySeverity() {
        return this.advisorySeverity;
    }

    public Date getTimeIssueDateStart() {
        return this.timeIssueDateStart;
    }

    public Date getTimeIssueDateEnd() {
        return this.timeIssueDateEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).name(this.name).nameContains(this.nameContains).classificationType(this.classificationType).advisoryType(this.advisoryType).osFamily(this.osFamily).advisorySeverity(this.advisorySeverity).timeIssueDateStart(this.timeIssueDateStart).timeIssueDateEnd(this.timeIssueDateEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",nameContains=").append(String.valueOf(this.nameContains));
        sb.append(",classificationType=").append(String.valueOf(this.classificationType));
        sb.append(",advisoryType=").append(String.valueOf(this.advisoryType));
        sb.append(",osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(",advisorySeverity=").append(String.valueOf(this.advisorySeverity));
        sb.append(",timeIssueDateStart=").append(String.valueOf(this.timeIssueDateStart));
        sb.append(",timeIssueDateEnd=").append(String.valueOf(this.timeIssueDateEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListErrataRequest)) {
            return false;
        }
        ListErrataRequest other = (ListErrataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.nameContains, other.nameContains) && Objects.equals(this.classificationType, other.classificationType) && Objects.equals(this.advisoryType, other.advisoryType) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.advisorySeverity, other.advisorySeverity) && Objects.equals(this.timeIssueDateStart, other.timeIssueDateStart) && Objects.equals(this.timeIssueDateEnd, other.timeIssueDateEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.nameContains == null ? 43 : this.nameContains.hashCode());
        result = result * 59 + (this.classificationType == null ? 43 : this.classificationType.hashCode());
        result = result * 59 + (this.advisoryType == null ? 43 : this.advisoryType.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.advisorySeverity == null ? 43 : this.advisorySeverity.hashCode());
        result = result * 59 + (this.timeIssueDateStart == null ? 43 : this.timeIssueDateStart.hashCode());
        result = result * 59 + (this.timeIssueDateEnd == null ? 43 : this.timeIssueDateEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListErrataRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> name = null;
        private String nameContains = null;
        private List<ClassificationTypes> classificationType = null;
        private List<AdvisoryTypes> advisoryType = null;
        private OsFamily osFamily = null;
        private List<AdvisorySeverity> advisorySeverity = null;
        private Date timeIssueDateStart = null;
        private Date timeIssueDateEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(List<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String singularValue) {
            return this.name(Arrays.asList(singularValue));
        }

        public Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public Builder classificationType(List<ClassificationTypes> classificationType) {
            this.classificationType = classificationType;
            return this;
        }

        public Builder classificationType(ClassificationTypes singularValue) {
            return this.classificationType(Arrays.asList(singularValue));
        }

        public Builder advisoryType(List<AdvisoryTypes> advisoryType) {
            this.advisoryType = advisoryType;
            return this;
        }

        public Builder advisoryType(AdvisoryTypes singularValue) {
            return this.advisoryType(Arrays.asList(singularValue));
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder advisorySeverity(List<AdvisorySeverity> advisorySeverity) {
            this.advisorySeverity = advisorySeverity;
            return this;
        }

        public Builder advisorySeverity(AdvisorySeverity singularValue) {
            return this.advisorySeverity(Arrays.asList(singularValue));
        }

        public Builder timeIssueDateStart(Date timeIssueDateStart) {
            this.timeIssueDateStart = timeIssueDateStart;
            return this;
        }

        public Builder timeIssueDateEnd(Date timeIssueDateEnd) {
            this.timeIssueDateEnd = timeIssueDateEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListErrataRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.nameContains(o.getNameContains());
            this.classificationType(o.getClassificationType());
            this.advisoryType(o.getAdvisoryType());
            this.osFamily(o.getOsFamily());
            this.advisorySeverity(o.getAdvisorySeverity());
            this.timeIssueDateStart(o.getTimeIssueDateStart());
            this.timeIssueDateEnd(o.getTimeIssueDateEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListErrataRequest build() {
            ListErrataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListErrataRequest buildWithoutInvocationCallback() {
            ListErrataRequest request = new ListErrataRequest();
            request.compartmentId = this.compartmentId;
            request.name = this.name;
            request.nameContains = this.nameContains;
            request.classificationType = this.classificationType;
            request.advisoryType = this.advisoryType;
            request.osFamily = this.osFamily;
            request.advisorySeverity = this.advisorySeverity;
            request.timeIssueDateStart = this.timeIssueDateStart;
            request.timeIssueDateEnd = this.timeIssueDateEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeIssued("timeIssued"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

