/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.Event;
import com.oracle.bmc.osmanagementhub.model.EventType;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListEventsRequest
extends BmcRequest<Void> {
    private String eventSummary;
    private String eventSummaryContains;
    private String id;
    private String eventFingerprint;
    private String compartmentId;
    private Event.LifecycleState lifecycleState;
    private String resourceId;
    private List<EventType> type;
    private Integer limit;
    private String page;
    private Date timeCreatedLessThan;
    private Date timeCreatedGreaterThanOrEqualTo;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private Boolean isManagedByAutonomousLinux;

    public String getEventSummary() {
        return this.eventSummary;
    }

    public String getEventSummaryContains() {
        return this.eventSummaryContains;
    }

    public String getId() {
        return this.id;
    }

    public String getEventFingerprint() {
        return this.eventFingerprint;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Event.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public List<EventType> getType() {
        return this.type;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Builder toBuilder() {
        return new Builder().eventSummary(this.eventSummary).eventSummaryContains(this.eventSummaryContains).id(this.id).eventFingerprint(this.eventFingerprint).compartmentId(this.compartmentId).lifecycleState(this.lifecycleState).resourceId(this.resourceId).type(this.type).limit(this.limit).page(this.page).timeCreatedLessThan(this.timeCreatedLessThan).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",eventSummary=").append(String.valueOf(this.eventSummary));
        sb.append(",eventSummaryContains=").append(String.valueOf(this.eventSummaryContains));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",eventFingerprint=").append(String.valueOf(this.eventFingerprint));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",resourceId=").append(String.valueOf(this.resourceId));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListEventsRequest)) {
            return false;
        }
        ListEventsRequest other = (ListEventsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.eventSummary, other.eventSummary) && Objects.equals(this.eventSummaryContains, other.eventSummaryContains) && Objects.equals(this.id, other.id) && Objects.equals(this.eventFingerprint, other.eventFingerprint) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.type, other.type) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.eventSummary == null ? 43 : this.eventSummary.hashCode());
        result = result * 59 + (this.eventSummaryContains == null ? 43 : this.eventSummaryContains.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.eventFingerprint == null ? 43 : this.eventFingerprint.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListEventsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String eventSummary = null;
        private String eventSummaryContains = null;
        private String id = null;
        private String eventFingerprint = null;
        private String compartmentId = null;
        private Event.LifecycleState lifecycleState = null;
        private String resourceId = null;
        private List<EventType> type = null;
        private Integer limit = null;
        private String page = null;
        private Date timeCreatedLessThan = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private Boolean isManagedByAutonomousLinux = null;

        public Builder eventSummary(String eventSummary) {
            this.eventSummary = eventSummary;
            return this;
        }

        public Builder eventSummaryContains(String eventSummaryContains) {
            this.eventSummaryContains = eventSummaryContains;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder eventFingerprint(String eventFingerprint) {
            this.eventFingerprint = eventFingerprint;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder lifecycleState(Event.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder type(List<EventType> type) {
            this.type = type;
            return this;
        }

        public Builder type(EventType singularValue) {
            return this.type(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListEventsRequest o) {
            this.eventSummary(o.getEventSummary());
            this.eventSummaryContains(o.getEventSummaryContains());
            this.id(o.getId());
            this.eventFingerprint(o.getEventFingerprint());
            this.compartmentId(o.getCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.resourceId(o.getResourceId());
            this.type(o.getType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListEventsRequest build() {
            ListEventsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListEventsRequest buildWithoutInvocationCallback() {
            ListEventsRequest request = new ListEventsRequest();
            request.eventSummary = this.eventSummary;
            request.eventSummaryContains = this.eventSummaryContains;
            request.id = this.id;
            request.eventFingerprint = this.eventFingerprint;
            request.compartmentId = this.compartmentId;
            request.lifecycleState = this.lifecycleState;
            request.resourceId = this.resourceId;
            request.type = this.type;
            request.limit = this.limit;
            request.page = this.page;
            request.timeCreatedLessThan = this.timeCreatedLessThan;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeOccurredAt("timeOccurredAt"),
        TimeUpdated("timeUpdated"),
        EventSummary("eventSummary");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

