/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceStatus;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListManagedInstancesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> displayName;
    private String displayNameContains;
    private String managedInstanceId;
    private List<ManagedInstanceStatus> status;
    private List<ArchType> archType;
    private List<OsFamily> osFamily;
    private Boolean isManagementStation;
    private String group;
    private String groupNotEqualTo;
    private String lifecycleStage;
    private String lifecycleStageNotEqualTo;
    private Boolean isAttachedToGroupOrLifecycleStage;
    private String softwareSourceId;
    private List<String> advisoryName;
    private String lifecycleEnvironment;
    private String lifecycleEnvironmentNotEqualTo;
    private List<ManagedInstanceLocation> location;
    private List<ManagedInstanceLocation> locationNotEqualTo;
    private List<String> profile;
    private List<String> profileNotEqualTo;
    private Boolean isProfileAttached;
    private Boolean isManagedByAutonomousLinux;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public List<ManagedInstanceStatus> getStatus() {
        return this.status;
    }

    public List<ArchType> getArchType() {
        return this.archType;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public Boolean getIsManagementStation() {
        return this.isManagementStation;
    }

    public String getGroup() {
        return this.group;
    }

    public String getGroupNotEqualTo() {
        return this.groupNotEqualTo;
    }

    public String getLifecycleStage() {
        return this.lifecycleStage;
    }

    public String getLifecycleStageNotEqualTo() {
        return this.lifecycleStageNotEqualTo;
    }

    public Boolean getIsAttachedToGroupOrLifecycleStage() {
        return this.isAttachedToGroupOrLifecycleStage;
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public List<String> getAdvisoryName() {
        return this.advisoryName;
    }

    public String getLifecycleEnvironment() {
        return this.lifecycleEnvironment;
    }

    public String getLifecycleEnvironmentNotEqualTo() {
        return this.lifecycleEnvironmentNotEqualTo;
    }

    public List<ManagedInstanceLocation> getLocation() {
        return this.location;
    }

    public List<ManagedInstanceLocation> getLocationNotEqualTo() {
        return this.locationNotEqualTo;
    }

    public List<String> getProfile() {
        return this.profile;
    }

    public List<String> getProfileNotEqualTo() {
        return this.profileNotEqualTo;
    }

    public Boolean getIsProfileAttached() {
        return this.isProfileAttached;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).displayNameContains(this.displayNameContains).managedInstanceId(this.managedInstanceId).status(this.status).archType(this.archType).osFamily(this.osFamily).isManagementStation(this.isManagementStation).group(this.group).groupNotEqualTo(this.groupNotEqualTo).lifecycleStage(this.lifecycleStage).lifecycleStageNotEqualTo(this.lifecycleStageNotEqualTo).isAttachedToGroupOrLifecycleStage(this.isAttachedToGroupOrLifecycleStage).softwareSourceId(this.softwareSourceId).advisoryName(this.advisoryName).lifecycleEnvironment(this.lifecycleEnvironment).lifecycleEnvironmentNotEqualTo(this.lifecycleEnvironmentNotEqualTo).location(this.location).locationNotEqualTo(this.locationNotEqualTo).profile(this.profile).profileNotEqualTo(this.profileNotEqualTo).isProfileAttached(this.isProfileAttached).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",archType=").append(String.valueOf(this.archType));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",isManagementStation=").append(String.valueOf(this.isManagementStation));
        sb.append(",group=").append(String.valueOf(this.group));
        sb.append(",groupNotEqualTo=").append(String.valueOf(this.groupNotEqualTo));
        sb.append(",lifecycleStage=").append(String.valueOf(this.lifecycleStage));
        sb.append(",lifecycleStageNotEqualTo=").append(String.valueOf(this.lifecycleStageNotEqualTo));
        sb.append(",isAttachedToGroupOrLifecycleStage=").append(String.valueOf(this.isAttachedToGroupOrLifecycleStage));
        sb.append(",softwareSourceId=").append(String.valueOf(this.softwareSourceId));
        sb.append(",advisoryName=").append(String.valueOf(this.advisoryName));
        sb.append(",lifecycleEnvironment=").append(String.valueOf(this.lifecycleEnvironment));
        sb.append(",lifecycleEnvironmentNotEqualTo=").append(String.valueOf(this.lifecycleEnvironmentNotEqualTo));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",locationNotEqualTo=").append(String.valueOf(this.locationNotEqualTo));
        sb.append(",profile=").append(String.valueOf(this.profile));
        sb.append(",profileNotEqualTo=").append(String.valueOf(this.profileNotEqualTo));
        sb.append(",isProfileAttached=").append(String.valueOf(this.isProfileAttached));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListManagedInstancesRequest)) {
            return false;
        }
        ListManagedInstancesRequest other = (ListManagedInstancesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.status, other.status) && Objects.equals(this.archType, other.archType) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.isManagementStation, other.isManagementStation) && Objects.equals(this.group, other.group) && Objects.equals(this.groupNotEqualTo, other.groupNotEqualTo) && Objects.equals(this.lifecycleStage, other.lifecycleStage) && Objects.equals(this.lifecycleStageNotEqualTo, other.lifecycleStageNotEqualTo) && Objects.equals(this.isAttachedToGroupOrLifecycleStage, other.isAttachedToGroupOrLifecycleStage) && Objects.equals(this.softwareSourceId, other.softwareSourceId) && Objects.equals(this.advisoryName, other.advisoryName) && Objects.equals(this.lifecycleEnvironment, other.lifecycleEnvironment) && Objects.equals(this.lifecycleEnvironmentNotEqualTo, other.lifecycleEnvironmentNotEqualTo) && Objects.equals(this.location, other.location) && Objects.equals(this.locationNotEqualTo, other.locationNotEqualTo) && Objects.equals(this.profile, other.profile) && Objects.equals(this.profileNotEqualTo, other.profileNotEqualTo) && Objects.equals(this.isProfileAttached, other.isProfileAttached) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.isManagementStation == null ? 43 : this.isManagementStation.hashCode());
        result = result * 59 + (this.group == null ? 43 : this.group.hashCode());
        result = result * 59 + (this.groupNotEqualTo == null ? 43 : this.groupNotEqualTo.hashCode());
        result = result * 59 + (this.lifecycleStage == null ? 43 : this.lifecycleStage.hashCode());
        result = result * 59 + (this.lifecycleStageNotEqualTo == null ? 43 : this.lifecycleStageNotEqualTo.hashCode());
        result = result * 59 + (this.isAttachedToGroupOrLifecycleStage == null ? 43 : this.isAttachedToGroupOrLifecycleStage.hashCode());
        result = result * 59 + (this.softwareSourceId == null ? 43 : this.softwareSourceId.hashCode());
        result = result * 59 + (this.advisoryName == null ? 43 : this.advisoryName.hashCode());
        result = result * 59 + (this.lifecycleEnvironment == null ? 43 : this.lifecycleEnvironment.hashCode());
        result = result * 59 + (this.lifecycleEnvironmentNotEqualTo == null ? 43 : this.lifecycleEnvironmentNotEqualTo.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.locationNotEqualTo == null ? 43 : this.locationNotEqualTo.hashCode());
        result = result * 59 + (this.profile == null ? 43 : this.profile.hashCode());
        result = result * 59 + (this.profileNotEqualTo == null ? 43 : this.profileNotEqualTo.hashCode());
        result = result * 59 + (this.isProfileAttached == null ? 43 : this.isProfileAttached.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListManagedInstancesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> displayName = null;
        private String displayNameContains = null;
        private String managedInstanceId = null;
        private List<ManagedInstanceStatus> status = null;
        private List<ArchType> archType = null;
        private List<OsFamily> osFamily = null;
        private Boolean isManagementStation = null;
        private String group = null;
        private String groupNotEqualTo = null;
        private String lifecycleStage = null;
        private String lifecycleStageNotEqualTo = null;
        private Boolean isAttachedToGroupOrLifecycleStage = null;
        private String softwareSourceId = null;
        private List<String> advisoryName = null;
        private String lifecycleEnvironment = null;
        private String lifecycleEnvironmentNotEqualTo = null;
        private List<ManagedInstanceLocation> location = null;
        private List<ManagedInstanceLocation> locationNotEqualTo = null;
        private List<String> profile = null;
        private List<String> profileNotEqualTo = null;
        private Boolean isProfileAttached = null;
        private Boolean isManagedByAutonomousLinux = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(List<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String singularValue) {
            return this.displayName(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder status(List<ManagedInstanceStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ManagedInstanceStatus singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder archType(List<ArchType> archType) {
            this.archType = archType;
            return this;
        }

        public Builder archType(ArchType singularValue) {
            return this.archType(Arrays.asList(singularValue));
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder isManagementStation(Boolean isManagementStation) {
            this.isManagementStation = isManagementStation;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder groupNotEqualTo(String groupNotEqualTo) {
            this.groupNotEqualTo = groupNotEqualTo;
            return this;
        }

        public Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        public Builder lifecycleStageNotEqualTo(String lifecycleStageNotEqualTo) {
            this.lifecycleStageNotEqualTo = lifecycleStageNotEqualTo;
            return this;
        }

        public Builder isAttachedToGroupOrLifecycleStage(Boolean isAttachedToGroupOrLifecycleStage) {
            this.isAttachedToGroupOrLifecycleStage = isAttachedToGroupOrLifecycleStage;
            return this;
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder advisoryName(List<String> advisoryName) {
            this.advisoryName = advisoryName;
            return this;
        }

        public Builder advisoryName(String singularValue) {
            return this.advisoryName(Arrays.asList(singularValue));
        }

        public Builder lifecycleEnvironment(String lifecycleEnvironment) {
            this.lifecycleEnvironment = lifecycleEnvironment;
            return this;
        }

        public Builder lifecycleEnvironmentNotEqualTo(String lifecycleEnvironmentNotEqualTo) {
            this.lifecycleEnvironmentNotEqualTo = lifecycleEnvironmentNotEqualTo;
            return this;
        }

        public Builder location(List<ManagedInstanceLocation> location) {
            this.location = location;
            return this;
        }

        public Builder location(ManagedInstanceLocation singularValue) {
            return this.location(Arrays.asList(singularValue));
        }

        public Builder locationNotEqualTo(List<ManagedInstanceLocation> locationNotEqualTo) {
            this.locationNotEqualTo = locationNotEqualTo;
            return this;
        }

        public Builder locationNotEqualTo(ManagedInstanceLocation singularValue) {
            return this.locationNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder profile(List<String> profile) {
            this.profile = profile;
            return this;
        }

        public Builder profile(String singularValue) {
            return this.profile(Arrays.asList(singularValue));
        }

        public Builder profileNotEqualTo(List<String> profileNotEqualTo) {
            this.profileNotEqualTo = profileNotEqualTo;
            return this;
        }

        public Builder profileNotEqualTo(String singularValue) {
            return this.profileNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder isProfileAttached(Boolean isProfileAttached) {
            this.isProfileAttached = isProfileAttached;
            return this;
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListManagedInstancesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.managedInstanceId(o.getManagedInstanceId());
            this.status(o.getStatus());
            this.archType(o.getArchType());
            this.osFamily(o.getOsFamily());
            this.isManagementStation(o.getIsManagementStation());
            this.group(o.getGroup());
            this.groupNotEqualTo(o.getGroupNotEqualTo());
            this.lifecycleStage(o.getLifecycleStage());
            this.lifecycleStageNotEqualTo(o.getLifecycleStageNotEqualTo());
            this.isAttachedToGroupOrLifecycleStage(o.getIsAttachedToGroupOrLifecycleStage());
            this.softwareSourceId(o.getSoftwareSourceId());
            this.advisoryName(o.getAdvisoryName());
            this.lifecycleEnvironment(o.getLifecycleEnvironment());
            this.lifecycleEnvironmentNotEqualTo(o.getLifecycleEnvironmentNotEqualTo());
            this.location(o.getLocation());
            this.locationNotEqualTo(o.getLocationNotEqualTo());
            this.profile(o.getProfile());
            this.profileNotEqualTo(o.getProfileNotEqualTo());
            this.isProfileAttached(o.getIsProfileAttached());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListManagedInstancesRequest build() {
            ListManagedInstancesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListManagedInstancesRequest buildWithoutInvocationCallback() {
            ListManagedInstancesRequest request = new ListManagedInstancesRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.managedInstanceId = this.managedInstanceId;
            request.status = this.status;
            request.archType = this.archType;
            request.osFamily = this.osFamily;
            request.isManagementStation = this.isManagementStation;
            request.group = this.group;
            request.groupNotEqualTo = this.groupNotEqualTo;
            request.lifecycleStage = this.lifecycleStage;
            request.lifecycleStageNotEqualTo = this.lifecycleStageNotEqualTo;
            request.isAttachedToGroupOrLifecycleStage = this.isAttachedToGroupOrLifecycleStage;
            request.softwareSourceId = this.softwareSourceId;
            request.advisoryName = this.advisoryName;
            request.lifecycleEnvironment = this.lifecycleEnvironment;
            request.lifecycleEnvironmentNotEqualTo = this.lifecycleEnvironmentNotEqualTo;
            request.location = this.location;
            request.locationNotEqualTo = this.locationNotEqualTo;
            request.profile = this.profile;
            request.profileNotEqualTo = this.profileNotEqualTo;
            request.isProfileAttached = this.isProfileAttached;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

