/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ArchType;
import com.oracle.bmc.osmanagementhub.model.OsFamily;
import com.oracle.bmc.osmanagementhub.model.Profile;
import com.oracle.bmc.osmanagementhub.model.ProfileType;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.osmanagementhub.model.VendorName;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListProfilesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> displayName;
    private String displayNameContains;
    private List<ProfileType> profileType;
    private String profileId;
    private OsFamily osFamily;
    private ArchType archType;
    private List<Profile.RegistrationType> registrationType;
    private Boolean isDefaultProfile;
    private Boolean isServiceProvidedProfile;
    private VendorName vendorName;
    private Integer limit;
    private String page;
    private Profile.LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public List<ProfileType> getProfileType() {
        return this.profileType;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public ArchType getArchType() {
        return this.archType;
    }

    public List<Profile.RegistrationType> getRegistrationType() {
        return this.registrationType;
    }

    public Boolean getIsDefaultProfile() {
        return this.isDefaultProfile;
    }

    public Boolean getIsServiceProvidedProfile() {
        return this.isServiceProvidedProfile;
    }

    public VendorName getVendorName() {
        return this.vendorName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Profile.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).displayNameContains(this.displayNameContains).profileType(this.profileType).profileId(this.profileId).osFamily(this.osFamily).archType(this.archType).registrationType(this.registrationType).isDefaultProfile(this.isDefaultProfile).isServiceProvidedProfile(this.isServiceProvidedProfile).vendorName(this.vendorName).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",profileType=").append(String.valueOf(this.profileType));
        sb.append(",profileId=").append(String.valueOf(this.profileId));
        sb.append(",osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(",archType=").append(String.valueOf((Object)this.archType));
        sb.append(",registrationType=").append(String.valueOf(this.registrationType));
        sb.append(",isDefaultProfile=").append(String.valueOf(this.isDefaultProfile));
        sb.append(",isServiceProvidedProfile=").append(String.valueOf(this.isServiceProvidedProfile));
        sb.append(",vendorName=").append(String.valueOf((Object)this.vendorName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProfilesRequest)) {
            return false;
        }
        ListProfilesRequest other = (ListProfilesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.profileType, other.profileType) && Objects.equals(this.profileId, other.profileId) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.archType, (Object)other.archType) && Objects.equals(this.registrationType, other.registrationType) && Objects.equals(this.isDefaultProfile, other.isDefaultProfile) && Objects.equals(this.isServiceProvidedProfile, other.isServiceProvidedProfile) && Objects.equals((Object)this.vendorName, (Object)other.vendorName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.profileType == null ? 43 : this.profileType.hashCode());
        result = result * 59 + (this.profileId == null ? 43 : this.profileId.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.archType == null ? 43 : this.archType.hashCode());
        result = result * 59 + (this.registrationType == null ? 43 : this.registrationType.hashCode());
        result = result * 59 + (this.isDefaultProfile == null ? 43 : this.isDefaultProfile.hashCode());
        result = result * 59 + (this.isServiceProvidedProfile == null ? 43 : this.isServiceProvidedProfile.hashCode());
        result = result * 59 + (this.vendorName == null ? 43 : this.vendorName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProfilesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> displayName = null;
        private String displayNameContains = null;
        private List<ProfileType> profileType = null;
        private String profileId = null;
        private OsFamily osFamily = null;
        private ArchType archType = null;
        private List<Profile.RegistrationType> registrationType = null;
        private Boolean isDefaultProfile = null;
        private Boolean isServiceProvidedProfile = null;
        private VendorName vendorName = null;
        private Integer limit = null;
        private String page = null;
        private Profile.LifecycleState lifecycleState = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(List<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String singularValue) {
            return this.displayName(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder profileType(List<ProfileType> profileType) {
            this.profileType = profileType;
            return this;
        }

        public Builder profileType(ProfileType singularValue) {
            return this.profileType(Arrays.asList(singularValue));
        }

        public Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder archType(ArchType archType) {
            this.archType = archType;
            return this;
        }

        public Builder registrationType(List<Profile.RegistrationType> registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        public Builder registrationType(Profile.RegistrationType singularValue) {
            return this.registrationType(Arrays.asList(singularValue));
        }

        public Builder isDefaultProfile(Boolean isDefaultProfile) {
            this.isDefaultProfile = isDefaultProfile;
            return this;
        }

        public Builder isServiceProvidedProfile(Boolean isServiceProvidedProfile) {
            this.isServiceProvidedProfile = isServiceProvidedProfile;
            return this;
        }

        public Builder vendorName(VendorName vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(Profile.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProfilesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.profileType(o.getProfileType());
            this.profileId(o.getProfileId());
            this.osFamily(o.getOsFamily());
            this.archType(o.getArchType());
            this.registrationType(o.getRegistrationType());
            this.isDefaultProfile(o.getIsDefaultProfile());
            this.isServiceProvidedProfile(o.getIsServiceProvidedProfile());
            this.vendorName(o.getVendorName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProfilesRequest build() {
            ListProfilesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListProfilesRequest buildWithoutInvocationCallback() {
            ListProfilesRequest request = new ListProfilesRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.profileType = this.profileType;
            request.profileId = this.profileId;
            request.osFamily = this.osFamily;
            request.archType = this.archType;
            request.registrationType = this.registrationType;
            request.isDefaultProfile = this.isDefaultProfile;
            request.isServiceProvidedProfile = this.isServiceProvidedProfile;
            request.vendorName = this.vendorName;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

