/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagementhub.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.osmanagementhub.model.ManagedInstanceLocation;
import com.oracle.bmc.osmanagementhub.model.OperationTypes;
import com.oracle.bmc.osmanagementhub.model.ScheduleTypes;
import com.oracle.bmc.osmanagementhub.model.ScheduledJob;
import com.oracle.bmc.osmanagementhub.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListScheduledJobsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String displayName;
    private String displayNameContains;
    private ScheduledJob.LifecycleState lifecycleState;
    private String managedInstanceId;
    private String managedInstanceGroupId;
    private String managedCompartmentId;
    private String lifecycleStageId;
    private OperationTypes operationType;
    private ScheduleTypes scheduleType;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private Boolean isRestricted;
    private String id;
    private Boolean compartmentIdInSubtree;
    private List<ManagedInstanceLocation> location;
    private List<ManagedInstanceLocation> locationNotEqualTo;
    private Boolean isManagedByAutonomousLinux;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public ScheduledJob.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getManagedInstanceGroupId() {
        return this.managedInstanceGroupId;
    }

    public String getManagedCompartmentId() {
        return this.managedCompartmentId;
    }

    public String getLifecycleStageId() {
        return this.lifecycleStageId;
    }

    public OperationTypes getOperationType() {
        return this.operationType;
    }

    public ScheduleTypes getScheduleType() {
        return this.scheduleType;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsRestricted() {
        return this.isRestricted;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public List<ManagedInstanceLocation> getLocation() {
        return this.location;
    }

    public List<ManagedInstanceLocation> getLocationNotEqualTo() {
        return this.locationNotEqualTo;
    }

    public Boolean getIsManagedByAutonomousLinux() {
        return this.isManagedByAutonomousLinux;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).displayName(this.displayName).displayNameContains(this.displayNameContains).lifecycleState(this.lifecycleState).managedInstanceId(this.managedInstanceId).managedInstanceGroupId(this.managedInstanceGroupId).managedCompartmentId(this.managedCompartmentId).lifecycleStageId(this.lifecycleStageId).operationType(this.operationType).scheduleType(this.scheduleType).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).isRestricted(this.isRestricted).id(this.id).compartmentIdInSubtree(this.compartmentIdInSubtree).location(this.location).locationNotEqualTo(this.locationNotEqualTo).isManagedByAutonomousLinux(this.isManagedByAutonomousLinux);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",managedInstanceGroupId=").append(String.valueOf(this.managedInstanceGroupId));
        sb.append(",managedCompartmentId=").append(String.valueOf(this.managedCompartmentId));
        sb.append(",lifecycleStageId=").append(String.valueOf(this.lifecycleStageId));
        sb.append(",operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(",scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isRestricted=").append(String.valueOf(this.isRestricted));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",locationNotEqualTo=").append(String.valueOf(this.locationNotEqualTo));
        sb.append(",isManagedByAutonomousLinux=").append(String.valueOf(this.isManagedByAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListScheduledJobsRequest)) {
            return false;
        }
        ListScheduledJobsRequest other = (ListScheduledJobsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.managedInstanceGroupId, other.managedInstanceGroupId) && Objects.equals(this.managedCompartmentId, other.managedCompartmentId) && Objects.equals(this.lifecycleStageId, other.lifecycleStageId) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isRestricted, other.isRestricted) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.location, other.location) && Objects.equals(this.locationNotEqualTo, other.locationNotEqualTo) && Objects.equals(this.isManagedByAutonomousLinux, other.isManagedByAutonomousLinux);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.managedInstanceGroupId == null ? 43 : this.managedInstanceGroupId.hashCode());
        result = result * 59 + (this.managedCompartmentId == null ? 43 : this.managedCompartmentId.hashCode());
        result = result * 59 + (this.lifecycleStageId == null ? 43 : this.lifecycleStageId.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isRestricted == null ? 43 : this.isRestricted.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.locationNotEqualTo == null ? 43 : this.locationNotEqualTo.hashCode());
        result = result * 59 + (this.isManagedByAutonomousLinux == null ? 43 : this.isManagedByAutonomousLinux.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScheduledJobsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String displayName = null;
        private String displayNameContains = null;
        private ScheduledJob.LifecycleState lifecycleState = null;
        private String managedInstanceId = null;
        private String managedInstanceGroupId = null;
        private String managedCompartmentId = null;
        private String lifecycleStageId = null;
        private OperationTypes operationType = null;
        private ScheduleTypes scheduleType = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private Boolean isRestricted = null;
        private String id = null;
        private Boolean compartmentIdInSubtree = null;
        private List<ManagedInstanceLocation> location = null;
        private List<ManagedInstanceLocation> locationNotEqualTo = null;
        private Boolean isManagedByAutonomousLinux = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(ScheduledJob.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder managedInstanceGroupId(String managedInstanceGroupId) {
            this.managedInstanceGroupId = managedInstanceGroupId;
            return this;
        }

        public Builder managedCompartmentId(String managedCompartmentId) {
            this.managedCompartmentId = managedCompartmentId;
            return this;
        }

        public Builder lifecycleStageId(String lifecycleStageId) {
            this.lifecycleStageId = lifecycleStageId;
            return this;
        }

        public Builder operationType(OperationTypes operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder scheduleType(ScheduleTypes scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder location(List<ManagedInstanceLocation> location) {
            this.location = location;
            return this;
        }

        public Builder location(ManagedInstanceLocation singularValue) {
            return this.location(Arrays.asList(singularValue));
        }

        public Builder locationNotEqualTo(List<ManagedInstanceLocation> locationNotEqualTo) {
            this.locationNotEqualTo = locationNotEqualTo;
            return this;
        }

        public Builder locationNotEqualTo(ManagedInstanceLocation singularValue) {
            return this.locationNotEqualTo(Arrays.asList(singularValue));
        }

        public Builder isManagedByAutonomousLinux(Boolean isManagedByAutonomousLinux) {
            this.isManagedByAutonomousLinux = isManagedByAutonomousLinux;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScheduledJobsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.managedInstanceId(o.getManagedInstanceId());
            this.managedInstanceGroupId(o.getManagedInstanceGroupId());
            this.managedCompartmentId(o.getManagedCompartmentId());
            this.lifecycleStageId(o.getLifecycleStageId());
            this.operationType(o.getOperationType());
            this.scheduleType(o.getScheduleType());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.isRestricted(o.getIsRestricted());
            this.id(o.getId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.location(o.getLocation());
            this.locationNotEqualTo(o.getLocationNotEqualTo());
            this.isManagedByAutonomousLinux(o.getIsManagedByAutonomousLinux());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScheduledJobsRequest build() {
            ListScheduledJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListScheduledJobsRequest buildWithoutInvocationCallback() {
            ListScheduledJobsRequest request = new ListScheduledJobsRequest();
            request.compartmentId = this.compartmentId;
            request.displayName = this.displayName;
            request.displayNameContains = this.displayNameContains;
            request.lifecycleState = this.lifecycleState;
            request.managedInstanceId = this.managedInstanceId;
            request.managedInstanceGroupId = this.managedInstanceGroupId;
            request.managedCompartmentId = this.managedCompartmentId;
            request.lifecycleStageId = this.lifecycleStageId;
            request.operationType = this.operationType;
            request.scheduleType = this.scheduleType;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.isRestricted = this.isRestricted;
            request.id = this.id;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.location = this.location;
            request.locationNotEqualTo = this.locationNotEqualTo;
            request.isManagedByAutonomousLinux = this.isManagedByAutonomousLinux;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

